/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import io.pivotal.cfenv.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CfCredentials {
    private final Map<String, Object> credentialsData;
    private UriInfo uriInfo;
    private final Map<String, String> derivedCredentials = new HashMap<String, String>();

    public CfCredentials(Map<String, Object> credentialsData) {
        this.credentialsData = credentialsData;
    }

    private synchronized UriInfo createOrGetUriInfo() {
        if (this.uriInfo == null && (this.credentialsData.containsKey("uri") || this.credentialsData.containsKey("url"))) {
            this.uriInfo = new UriInfo(this.getString("uri", "url"));
        }
        return this.uriInfo;
    }

    public Map<String, Object> getMap() {
        return this.credentialsData;
    }

    public Map<String, String> getDerivedCredentials() {
        return this.derivedCredentials;
    }

    public String getHost() {
        String host = this.getString("host", "hostname");
        if (host != null) {
            return host;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getHost() : null;
    }

    public String getPort() {
        String port = this.getString("port");
        if (port != null) {
            return port;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? String.valueOf(uriInfo.getPort()) : null;
    }

    public String getName() {
        return this.getString("name");
    }

    public String getUsername() {
        String username = this.getString("username", "user", "Username");
        if (username != null) {
            return username;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getUsername() : null;
    }

    public String getPassword() {
        String password = this.getString("password", "Password");
        if (password != null) {
            return password;
        }
        UriInfo uriInfo = this.createOrGetUriInfo();
        return uriInfo != null ? uriInfo.getPassword() : null;
    }

    public String getUri(String ... uriSchemes) {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.addAll(Arrays.asList("uri", "url"));
        for (String uriScheme : uriSchemes) {
            keys.add(uriScheme + "Uri");
            keys.add(uriScheme + "uri");
            keys.add(uriScheme + "Url");
            keys.add(uriScheme + "url");
        }
        return this.getString(keys.toArray(new String[keys.size()]));
    }

    public UriInfo getUriInfo() {
        return this.createOrGetUriInfo();
    }

    public UriInfo getUriInfo(String uriScheme) {
        UriInfo uriInfo;
        String uri = this.getUri(uriScheme);
        if (uri == null) {
            String hostname = this.getHost();
            String port = this.getPort();
            String username = this.getUsername();
            String password = this.getPassword();
            String databaseName = this.getName();
            uriInfo = new UriInfo(uriScheme, hostname, Integer.parseInt(port), username, password, databaseName);
        } else {
            uri = uri.startsWith("jdbc:") ? uri.split("jdbc:")[1] : uri;
            uriInfo = new UriInfo(uri);
        }
        return uriInfo;
    }

    public String getString(String ... keys) {
        if (this.credentialsData != null) {
            for (String key : keys) {
                if (!this.credentialsData.containsKey(key)) continue;
                return this.credentialsData.get(key).toString();
            }
        }
        return null;
    }
}

