/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class UriInfo {
    private String scheme;
    private String host;
    private int port;
    private String userName;
    private String password;
    private String path;
    private String query;
    private String schemeSpecificPart;
    private String uriString;

    public UriInfo(String scheme, String host, int port, String username, String password) {
        this(scheme, host, port, username, password, null, null);
    }

    public UriInfo(String scheme, String host, int port, String username, String password, String path) {
        this(scheme, host, port, username, password, path, null);
    }

    public UriInfo(String scheme, String host, int port, String username, String password, String path, String query) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.userName = username;
        this.password = password;
        this.path = path;
        this.query = query;
        this.uriString = this.buildUri().toString();
    }

    public UriInfo(String uriString) {
        this.uriString = uriString;
        URI uri = this.getUri();
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = this.parsePath(uri);
        this.query = uri.getQuery();
        this.schemeSpecificPart = uri.getSchemeSpecificPart();
        String[] userinfo = this.parseUserinfo(uri);
        this.userName = UriInfo.uriDecode(userinfo[0]);
        this.password = UriInfo.uriDecode(userinfo[1]);
    }

    private static String uriDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public URI getUri() {
        try {
            return new URI(this.uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI " + this.uriString, e);
        }
    }

    public String getUriString() {
        return this.uriString;
    }

    public String formatUserNameAndPassword() {
        if (this.userName != null && this.password != null) {
            return String.format("?user=%s&password=%s", UriInfo.urlEncode(this.userName), UriInfo.urlEncode(this.password));
        }
        if (this.userName != null) {
            return String.format("?user=%s", UriInfo.urlEncode(this.userName));
        }
        return "";
    }

    public String formatPort() {
        if (this.getPort() != -1) {
            return String.format(":%d", this.getPort());
        }
        return "";
    }

    public String formatQuery() {
        if (this.getQuery() != null) {
            if (this.formatUserNameAndPassword().isEmpty()) {
                return String.format("?%s", this.getQuery());
            }
            return String.format("&%s", this.getQuery());
        }
        return "";
    }

    private URI buildUri() {
        String userInfo = null;
        if (this.userName != null && this.password != null) {
            userInfo = this.userName + ":" + this.password;
        }
        String cleanedPath = this.path == null || this.path.startsWith("/") ? this.path : "/" + this.path;
        try {
            return new URI(this.scheme, userInfo, this.host, this.port, cleanedPath, this.query, null);
        }
        catch (URISyntaxException e) {
            String details = String.format("Error creating URI with components: scheme=%s, userInfo=%s, host=%s, port=%d, path=%s, query=%s", this.scheme, userInfo, this.host, this.port, cleanedPath, this.query);
            throw new IllegalArgumentException(details, e);
        }
    }

    private String[] parseUserinfo(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length != 2) {
                throw new IllegalArgumentException("Bad userinfo in URI: " + uri);
            }
            return userPass;
        }
        return new String[]{null, null};
    }

    private String parsePath(URI uri) {
        String rawPath = uri.getRawPath();
        if (rawPath != null && rawPath.length() > 1) {
            return rawPath.substring(1);
        }
        return null;
    }

    public String toString() {
        return this.uriString;
    }
}

