/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import java.util.Map;
import java.util.Optional;

public class RedisCfEnvProcessor
implements CfEnvProcessor {
    private static final String[] redisSchemes = new String[]{"redis", "rediss"};
    private static final String PREFIX = "spring.data.redis";

    @Override
    public boolean accept(CfService service) {
        boolean serviceIsBound;
        boolean bl = serviceIsBound = service.existsByTagIgnoreCase(new String[]{"redis"}) || service.existsByLabelStartsWith("rediscloud") || service.existsByUriSchemeStartsWith(redisSchemes) || service.existsByCredentialsContainsUriField(redisSchemes);
        if (serviceIsBound) {
            ConnectorLibraryDetector.assertNoConnectorLibrary();
        }
        return serviceIsBound;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(redisSchemes);
        if (uri == null) {
            properties.put("spring.data.redis.host", cfCredentials.getHost());
            properties.put("spring.data.redis.password", cfCredentials.getPassword());
            Optional<String> tlsPort = Optional.ofNullable(cfCredentials.getString(new String[]{"tls_port"}));
            if (tlsPort.isPresent()) {
                properties.put("spring.data.redis.port", tlsPort.get());
                properties.put("spring.data.redis.ssl", "true");
            } else {
                properties.put("spring.data.redis.port", cfCredentials.getPort());
            }
        } else {
            UriInfo uriInfo = new UriInfo(uri);
            properties.put("spring.data.redis.host", uriInfo.getHost());
            properties.put("spring.data.redis.port", uriInfo.getPort());
            properties.put("spring.data.redis.password", uriInfo.getPassword());
            if (uriInfo.getScheme().equals("rediss")) {
                properties.put("spring.data.redis.ssl", "true");
            }
        }
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes(PREFIX).serviceName("Redis").build();
    }
}

