/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.spring.boot.LogLevel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredLog
implements Log {
    private volatile Log destination;
    private final List<Line> lines = new ArrayList<Line>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTraceEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isTraceEnabled() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDebugEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isDebugEnabled() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInfoEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isInfoEnabled() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWarnEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isWarnEnabled() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isErrorEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isErrorEnabled() : true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFatalEnabled() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.destination != null ? this.destination.isFatalEnabled() : true;
        }
    }

    public void trace(Object message) {
        this.log(LogLevel.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(LogLevel.TRACE, message, t);
    }

    public void debug(Object message) {
        this.log(LogLevel.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(LogLevel.DEBUG, message, t);
    }

    public void info(Object message) {
        this.log(LogLevel.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(LogLevel.INFO, message, t);
    }

    public void warn(Object message) {
        this.log(LogLevel.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(LogLevel.WARN, message, t);
    }

    public void error(Object message) {
        this.log(LogLevel.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(LogLevel.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(LogLevel.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(LogLevel.FATAL, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LogLevel level, Object message, Throwable t) {
        List<Line> list = this.lines;
        synchronized (list) {
            if (this.destination != null) {
                DeferredLog.logTo(this.destination, level, message, t);
            } else {
                this.lines.add(new Line(level, message, t));
            }
        }
    }

    public void switchTo(Class<?> destination) {
        this.switchTo(LogFactory.getLog(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTo(Log destination) {
        List<Line> list = this.lines;
        synchronized (list) {
            this.replayTo(destination);
            this.destination = destination;
        }
    }

    public void replayTo(Class<?> destination) {
        this.replayTo(LogFactory.getLog(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayTo(Log destination) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                DeferredLog.logTo(destination, line.getLevel(), line.getMessage(), line.getThrowable());
            }
            this.lines.clear();
        }
    }

    public static Log replay(Log source, Class<?> destination) {
        return DeferredLog.replay(source, LogFactory.getLog(destination));
    }

    public static Log replay(Log source, Log destination) {
        if (source instanceof DeferredLog) {
            ((DeferredLog)source).replayTo(destination);
        }
        return destination;
    }

    private static void logTo(Log log, LogLevel level, Object message, Throwable throwable) {
        switch (level) {
            case TRACE: {
                log.trace(message, throwable);
                return;
            }
            case DEBUG: {
                log.debug(message, throwable);
                return;
            }
            case INFO: {
                log.info(message, throwable);
                return;
            }
            case WARN: {
                log.warn(message, throwable);
                return;
            }
            case ERROR: {
                log.error(message, throwable);
                return;
            }
            case FATAL: {
                log.fatal(message, throwable);
                return;
            }
        }
    }

    private static class Line {
        private final LogLevel level;
        private final Object message;
        private final Throwable throwable;

        Line(LogLevel level, Object message, Throwable throwable) {
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public Object getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

