/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfServiceEnablingEnvironmentPostProcessor;
import io.pivotal.cfenv.spring.boot.DeferredLog;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.stereotype.Component;

@Component
public class CfEnvironmentPostProcessor
implements CfServiceEnablingEnvironmentPostProcessor,
Ordered,
ApplicationListener<ApplicationEvent> {
    private static final DeferredLog DEFERRED_LOG = new DeferredLog();
    private static int invocationCount;
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.increaseInvocationCount();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive((Environment)environment)) {
            CfEnv cfEnv = new CfEnv();
            List allServices = cfEnv.findAllServices();
            List cfEnvProcessors = SpringFactoriesLoader.loadFactories(CfEnvProcessor.class, (ClassLoader)this.getClass().getClassLoader());
            AnnotationAwareOrderComparator.sort((List)cfEnvProcessors);
            for (CfEnvProcessor processor : cfEnvProcessors) {
                List cfServices = allServices.stream().filter(processor::accept).filter(cfService -> this.isEnabled((CfService)cfService, (Environment)environment)).collect(Collectors.toList());
                if (cfServices.size() > 1) {
                    List names = cfServices.stream().map(CfService::getName).collect(Collectors.toList());
                    DEFERRED_LOG.warn(String.format("Skipping auto-configuration: No unique %s service found. Found services named [%s]", processor.getProperties().getServiceName(), String.join((CharSequence)",", names)));
                    continue;
                }
                if (cfServices.size() != 1) continue;
                CfService cfService2 = (CfService)cfServices.get(0);
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                processor.process(cfService2.getCredentials(), properties);
                MutablePropertySources propertySources = environment.getPropertySources();
                if (propertySources.contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource(processor.getClass().getSimpleName(), properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource(processor.getClass().getSimpleName(), properties));
                }
                if (invocationCount != 1) continue;
                DEFERRED_LOG.info("Setting " + processor.getProperties().getPropertyPrefixes() + " properties from bound service [" + cfService2.getName() + "] using " + processor.getClass().getName());
            }
        } else if (invocationCount == 1) {
            DEFERRED_LOG.debug("Not setting properties, Cloud Foundry Environment no detected");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            DEFERRED_LOG.switchTo(CfEnvironmentPostProcessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseInvocationCount() {
        CfEnvironmentPostProcessor cfEnvironmentPostProcessor = this;
        synchronized (cfEnvironmentPostProcessor) {
            ++invocationCount;
        }
    }
}

