/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class AmqpCfEnvProcessor
implements CfEnvProcessor {
    private static String[] amqpSchemes = new String[]{"amqp", "amqps"};

    @Override
    public boolean accept(CfService service) {
        boolean serviceIsBound;
        boolean bl = serviceIsBound = service.existsByTagIgnoreCase(new String[]{"rabbitmq", "amqp"}) || service.existsByLabelStartsWith("rabbitmq") || service.existsByLabelStartsWith("cloudamqp") || service.existsByUriSchemeStartsWith(amqpSchemes) || service.existsByCredentialsContainsUriField(amqpSchemes);
        if (serviceIsBound) {
            ConnectorLibraryDetector.assertNoConnectorLibrary();
        }
        return serviceIsBound;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(amqpSchemes);
        if (uri == null) {
            properties.put("spring.rabbitmq.host", cfCredentials.getHost());
            properties.put("spring.rabbitmq.password", cfCredentials.getPassword());
            properties.put("spring.rabbitmq.username", cfCredentials.getUsername());
        } else {
            UriInfo uriInfo = new UriInfo(uri);
            properties.put("spring.rabbitmq.host", uriInfo.getHost());
            properties.put("spring.rabbitmq.password", uriInfo.getPassword());
            properties.put("spring.rabbitmq.username", cfCredentials.getUsername());
            if (uriInfo.getScheme().equals("amqps")) {
                properties.put("spring.rabbitmq.ssl.enabled", "true");
                properties.put("spring.rabbitmq.port", "5671");
            } else {
                this.populateAddress(cfCredentials, properties, uri);
            }
        }
        if (cfCredentials.getMap().get("vhost") != null) {
            properties.put("spring.rabbitmq.virtualHost", cfCredentials.getMap().get("vhost"));
        }
    }

    public void populateAddress(CfCredentials cfCredentials, Map<String, Object> properties, String uri) {
        if (cfCredentials.getMap().get("uris") != null) {
            properties.put("spring.rabbitmq.addresses", StringUtils.collectionToCommaDelimitedString((Collection)((List)cfCredentials.getMap().get("uris"))));
        } else if (uri != null) {
            properties.put("spring.rabbitmq.addresses", uri);
        }
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.rabbitmq").serviceName("Rabbit").build();
    }
}

