/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.sso;

import io.pivotal.cfenv.boot.sso.SpringSecurityDetector;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CfSingleSignOnProcessor
implements CfEnvProcessor {
    private static final String PIVOTAL_SSO_LABEL = "p-identity";
    private static final String SPRING_SECURITY_CLIENT = "spring.security.oauth2.client";
    private static final String PROVIDER_ID = "sso";
    private static final String BASE_CLIENT_REGISTRATION_ID = "sso";
    private static final String AUTHCODE_CLIENT_REGISTRATION_ID = "ssoauthorizationcode";
    private static final String CLIENTCRED_CLIENT_REGISTRATION_ID = "ssoclientcredentials";
    private static final String SSO_SERVICE = "ssoServiceUrl";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final Set<String> AUTH_CODE_AND_CLIENT_CREDS = new HashSet<String>(Arrays.asList("authorization_code", "client_credentials"));

    public boolean accept(CfService service) {
        return SpringSecurityDetector.isSpringSecurityPresent() && service.existsByLabelStartsWith(PIVOTAL_SSO_LABEL);
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String clientId = cfCredentials.getString(new String[]{"client_id"});
        String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
        String authDomain = cfCredentials.getString(new String[]{"auth_domain"});
        String issuer = this.fromAuthDomain(authDomain);
        properties.put(SSO_SERVICE, authDomain);
        properties.put("spring.security.oauth2.client.provider.sso.issuer-uri", issuer + "/oauth/token");
        properties.put("spring.security.oauth2.client.provider.sso.authorization-uri", authDomain + "/oauth/authorize");
        ArrayList grantTypes = (ArrayList)cfCredentials.getMap().get("grant_types");
        if (grantTypes != null && this.isAuthCodeAndClientCreds(grantTypes)) {
            this.mapBasicClientProperties(properties, AUTHCODE_CLIENT_REGISTRATION_ID, clientId, clientSecret);
            properties.put("spring.security.oauth2.client.registration.ssoauthorizationcode.authorization-grant-type", AUTHORIZATION_CODE);
            this.mapBasicClientProperties(properties, CLIENTCRED_CLIENT_REGISTRATION_ID, clientId, clientSecret);
            properties.put("spring.security.oauth2.client.registration.ssoclientcredentials.authorization-grant-type", CLIENT_CREDENTIALS);
        } else if (grantTypes != null && grantTypes.size() == 1) {
            this.mapBasicClientProperties(properties, "sso", clientId, clientSecret);
            String grantType = (String)grantTypes.get(0);
            properties.put("spring.security.oauth2.client.registration.sso.authorization-grant-type", grantType);
        } else {
            this.mapBasicClientProperties(properties, "sso", clientId, clientSecret);
        }
    }

    private boolean isAuthCodeAndClientCreds(ArrayList<String> grantTypes) {
        return new HashSet<String>(grantTypes).equals(AUTH_CODE_AND_CLIENT_CREDS);
    }

    private void mapBasicClientProperties(Map<String, Object> properties, String clientRegistrationId, String clientId, String clientSecret) {
        String registrationPrefix = "spring.security.oauth2.client.registration." + clientRegistrationId;
        properties.put(registrationPrefix + ".client-id", clientId);
        properties.put(registrationPrefix + ".client-secret", clientSecret);
        properties.put(registrationPrefix + ".client-name", clientRegistrationId);
        properties.put(registrationPrefix + ".redirect-uri", "{baseUrl}/login/oauth2/code/{registrationId}");
        properties.put(registrationPrefix + ".provider", "sso");
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes(String.join((CharSequence)",", SSO_SERVICE, SPRING_SECURITY_CLIENT)).serviceName("Single Sign On").build();
    }

    String fromAuthDomain(String authUri) {
        URI uri = URI.create(authUri);
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException("Unable to parse URI host from VCAP_SERVICES with label: \"p-identity\" and auth_domain: \"" + authUri + "\"");
        }
        String issuerHost = uri.getHost().replaceFirst("login\\.", "uaa.");
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), issuerHost, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

