/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.inference.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.inference.client.ApiCallback;
import org.openapitools.inference.client.ApiClient;
import org.openapitools.inference.client.ApiException;
import org.openapitools.inference.client.ApiResponse;
import org.openapitools.inference.client.Configuration;
import org.openapitools.inference.client.Pair;
import org.openapitools.inference.client.model.EmbedRequest;
import org.openapitools.inference.client.model.EmbeddingsList;
import org.openapitools.inference.client.model.ModelInfo;
import org.openapitools.inference.client.model.ModelInfoList;
import org.openapitools.inference.client.model.RerankRequest;
import org.openapitools.inference.client.model.RerankResult;

public class InferenceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InferenceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InferenceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call embedCall(EmbedRequest embedRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmbedRequest localVarPostBody = embedRequest;
        String localVarPath = "/embed";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call embedValidateBeforeCall(EmbedRequest embedRequest, ApiCallback _callback) throws ApiException {
        return this.embedCall(embedRequest, _callback);
    }

    public EmbeddingsList embed(EmbedRequest embedRequest) throws ApiException {
        ApiResponse<EmbeddingsList> localVarResp = this.embedWithHttpInfo(embedRequest);
        return localVarResp.getData();
    }

    public ApiResponse<EmbeddingsList> embedWithHttpInfo(EmbedRequest embedRequest) throws ApiException {
        Call localVarCall = this.embedValidateBeforeCall(embedRequest, null);
        Type localVarReturnType = new TypeToken<EmbeddingsList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call embedAsync(EmbedRequest embedRequest, ApiCallback<EmbeddingsList> _callback) throws ApiException {
        Call localVarCall = this.embedValidateBeforeCall(embedRequest, _callback);
        Type localVarReturnType = new TypeToken<EmbeddingsList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getModelCall(String modelName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/models/{model_name}".replace("{model_name}", this.localVarApiClient.escapeString(modelName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getModelValidateBeforeCall(String modelName, ApiCallback _callback) throws ApiException {
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling getModel(Async)");
        }
        return this.getModelCall(modelName, _callback);
    }

    public ModelInfo getModel(String modelName) throws ApiException {
        ApiResponse<ModelInfo> localVarResp = this.getModelWithHttpInfo(modelName);
        return localVarResp.getData();
    }

    public ApiResponse<ModelInfo> getModelWithHttpInfo(String modelName) throws ApiException {
        Call localVarCall = this.getModelValidateBeforeCall(modelName, null);
        Type localVarReturnType = new TypeToken<ModelInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getModelAsync(String modelName, ApiCallback<ModelInfo> _callback) throws ApiException {
        Call localVarCall = this.getModelValidateBeforeCall(modelName, _callback);
        Type localVarReturnType = new TypeToken<ModelInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listModelsCall(String type, String vectorType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/models";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (vectorType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("vector_type", vectorType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listModelsValidateBeforeCall(String type, String vectorType, ApiCallback _callback) throws ApiException {
        return this.listModelsCall(type, vectorType, _callback);
    }

    public ModelInfoList listModels(String type, String vectorType) throws ApiException {
        ApiResponse<ModelInfoList> localVarResp = this.listModelsWithHttpInfo(type, vectorType);
        return localVarResp.getData();
    }

    public ApiResponse<ModelInfoList> listModelsWithHttpInfo(String type, String vectorType) throws ApiException {
        Call localVarCall = this.listModelsValidateBeforeCall(type, vectorType, null);
        Type localVarReturnType = new TypeToken<ModelInfoList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listModelsAsync(String type, String vectorType, ApiCallback<ModelInfoList> _callback) throws ApiException {
        Call localVarCall = this.listModelsValidateBeforeCall(type, vectorType, _callback);
        Type localVarReturnType = new TypeToken<ModelInfoList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rerankCall(RerankRequest rerankRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RerankRequest localVarPostBody = rerankRequest;
        String localVarPath = "/rerank";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rerankValidateBeforeCall(RerankRequest rerankRequest, ApiCallback _callback) throws ApiException {
        return this.rerankCall(rerankRequest, _callback);
    }

    public RerankResult rerank(RerankRequest rerankRequest) throws ApiException {
        ApiResponse<RerankResult> localVarResp = this.rerankWithHttpInfo(rerankRequest);
        return localVarResp.getData();
    }

    public ApiResponse<RerankResult> rerankWithHttpInfo(RerankRequest rerankRequest) throws ApiException {
        Call localVarCall = this.rerankValidateBeforeCall(rerankRequest, null);
        Type localVarReturnType = new TypeToken<RerankResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rerankAsync(RerankRequest rerankRequest, ApiCallback<RerankResult> _callback) throws ApiException {
        Call localVarCall = this.rerankValidateBeforeCall(rerankRequest, _callback);
        Type localVarReturnType = new TypeToken<RerankResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

