/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.db_data.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import okio.ByteString;
import org.openapitools.db_data.client.model.DeleteRequest;
import org.openapitools.db_data.client.model.DescribeIndexStatsRequest;
import org.openapitools.db_data.client.model.FetchResponse;
import org.openapitools.db_data.client.model.Hit;
import org.openapitools.db_data.client.model.ImportErrorMode;
import org.openapitools.db_data.client.model.ImportModel;
import org.openapitools.db_data.client.model.IndexDescription;
import org.openapitools.db_data.client.model.ListImportsResponse;
import org.openapitools.db_data.client.model.ListItem;
import org.openapitools.db_data.client.model.ListNamespacesResponse;
import org.openapitools.db_data.client.model.ListResponse;
import org.openapitools.db_data.client.model.NamespaceDescription;
import org.openapitools.db_data.client.model.NamespaceSummary;
import org.openapitools.db_data.client.model.Pagination;
import org.openapitools.db_data.client.model.ProtobufAny;
import org.openapitools.db_data.client.model.QueryRequest;
import org.openapitools.db_data.client.model.QueryResponse;
import org.openapitools.db_data.client.model.QueryVector;
import org.openapitools.db_data.client.model.RpcStatus;
import org.openapitools.db_data.client.model.ScoredVector;
import org.openapitools.db_data.client.model.SearchRecordsRequest;
import org.openapitools.db_data.client.model.SearchRecordsRequestQuery;
import org.openapitools.db_data.client.model.SearchRecordsRequestRerank;
import org.openapitools.db_data.client.model.SearchRecordsResponse;
import org.openapitools.db_data.client.model.SearchRecordsResponseResult;
import org.openapitools.db_data.client.model.SearchRecordsVector;
import org.openapitools.db_data.client.model.SearchUsage;
import org.openapitools.db_data.client.model.SearchVector;
import org.openapitools.db_data.client.model.SingleQueryResults;
import org.openapitools.db_data.client.model.SparseValues;
import org.openapitools.db_data.client.model.StartImportRequest;
import org.openapitools.db_data.client.model.StartImportResponse;
import org.openapitools.db_data.client.model.UpdateRequest;
import org.openapitools.db_data.client.model.UpsertRecord;
import org.openapitools.db_data.client.model.UpsertRequest;
import org.openapitools.db_data.client.model.UpsertResponse;
import org.openapitools.db_data.client.model.Usage;
import org.openapitools.db_data.client.model.Vector;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public JSON() {
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter(java.util.Date.class, (Object)dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(Date.class, (Object)sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, (Object)byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DeleteRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DescribeIndexStatsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new FetchResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Hit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ImportErrorMode.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ImportModel.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new IndexDescription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ListImportsResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ListItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ListNamespacesResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NamespaceDescription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NamespaceSummary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Pagination.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ProtobufAny.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new QueryRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new QueryResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new QueryVector.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RpcStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScoredVector.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsRequestQuery.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsRequestRerank.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsResponseResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchRecordsVector.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchUsage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SearchVector.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SingleQueryResults.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SparseValues.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StartImportRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StartImportResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UpsertRecord.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UpsertRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UpsertResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Usage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Vector.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)gson.fromJson(jsonReader, returnType);
            }
            return (T)gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                out.value(value);
            }
        }

        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of((byte[])value).base64());
            }
        }

        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64((String)bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

