/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java15;

import io.perfmark.java15.MarkHolderRecorder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

final class Loader {
    static final int DEFAULT_SIZE = 32768;
    private static final int[] maxEventsOffsets;
    private static final int[] maxEventsMaskOffsets;
    private static final byte[] markHolderClassData;

    static Class<? extends MarkHolderRecorder> getHiddenClass(int size) throws IllegalAccessException {
        byte[] classData;
        if (size != 32768) {
            classData = (byte[])markHolderClassData.clone();
            Loader.replaceSize(classData, size, maxEventsOffsets, maxEventsMaskOffsets);
        } else {
            classData = markHolderClassData;
        }
        return MethodHandles.lookup().defineHiddenClass(classData, true, new MethodHandles.Lookup.ClassOption[0]).lookupClass().asSubclass(MarkHolderRecorder.class);
    }

    private static void replaceSize(byte[] haystack, int size, int[] maxEventsOffsets, int[] maxEventsMaskOffsets) {
        ByteBuffer buf = ByteBuffer.wrap(haystack).order(ByteOrder.BIG_ENDIAN);
        for (int off : maxEventsOffsets) {
            buf.putInt(off, size);
        }
        for (int off : maxEventsMaskOffsets) {
            buf.putLong(off, size - 1);
        }
    }

    private static int[] findOffsets(byte[] haystack, byte[] needle) {
        int[] matches = new int[]{};
        block0: for (int i = 0; i < haystack.length - needle.length; ++i) {
            for (int k = 0; k < needle.length; ++k) {
                if (haystack[i + k] != needle[k]) continue block0;
            }
            matches = Arrays.copyOf(matches, matches.length + 1);
            matches[matches.length - 1] = i;
        }
        return matches;
    }

    private Loader() {
    }

    static {
        byte[] classData;
        try (InputStream is = Loader.class.getResourceAsStream("HiddenClassVarHandleMarkHolder.class");){
            classData = is.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer expectedMaxEvents = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        expectedMaxEvents.putInt(2117564857);
        byte[] maxEvents = expectedMaxEvents.array();
        int[] maxOffsets = Loader.findOffsets(classData, maxEvents);
        if (maxOffsets.length != 2) {
            throw new RuntimeException("hop");
        }
        ByteBuffer expectedMaxEventsMask = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        expectedMaxEventsMask.putLong(2117564856L);
        byte[] maxEventsMax = expectedMaxEventsMask.array();
        int[] maskOffsets = Loader.findOffsets(classData, maxEventsMax);
        if (maskOffsets.length != 1) {
            throw new RuntimeException("skip");
        }
        Loader.replaceSize(classData, 32768, maxOffsets, maskOffsets);
        maxEventsOffsets = maxOffsets;
        maxEventsMaskOffsets = maskOffsets;
        markHolderClassData = classData;
    }
}

