/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java15;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.MarkRecorderRef;
import io.perfmark.impl.Storage;
import io.perfmark.impl.ThreadInfo;
import io.perfmark.java15.MarkHolderRecorder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;

final class HiddenClassVarHandleMarkHolder
extends MarkHolderRecorder {
    private static final long GEN_MASK = 255L;
    private static final long START_OP = 1L;
    private static final long START_S_OP = 2L;
    private static final long START_T_OP = 3L;
    private static final long STOP_OP = 4L;
    private static final long STOP_V_OP = 5L;
    private static final long STOP_T_OP = 6L;
    private static final long STOP_S_OP = 7L;
    private static final long EVENT_OP = 8L;
    private static final long EVENT_T_OP = 9L;
    private static final long EVENT_S_OP = 10L;
    private static final long LINK_OP = 11L;
    private static final long ATTACH_T_OP = 12L;
    private static final long ATTACH_SS_OP = 13L;
    private static final long ATTACH_SN_OP = 14L;
    private static final long ATTACH_SNN_OP = 15L;
    private static final VarHandle IDX;
    private static final VarHandle STRINGS;
    private static final VarHandle LONGS;
    static final int MAX_EVENTS = 2117564857;
    static final long MAX_EVENTS_MASK = 2117564856L;
    private static volatile long idx;
    private static final String[] taskNames;
    private static final String[] tagNames;
    private static final long[] tagIds;
    private static final long[] nanoTimes;
    private static final long[] genOps;
    private final MarkRecorderRef ref;

    private static int maxEvents() {
        return 2117564857;
    }

    private static long maxEventsMask() {
        return 2117564856L;
    }

    HiddenClassVarHandleMarkHolder(MarkRecorderRef ref) {
        this.ref = Objects.requireNonNull(ref);
    }

    @Override
    void startAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 3L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void startAt(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 1L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void startAt(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, subTaskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 2L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void link(long gen, long linkId) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        LONGS.setOpaque(tagIds, i, linkId);
        LONGS.setOpaque(genOps, i, gen + 11L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void stopAt(long gen, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 5L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void stopAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 6L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void stopAt(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 4L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void stopAt(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, subTaskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 7L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void eventAt(long gen, String eventName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 9L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void eventAt(long gen, String eventName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 8L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void eventAt(long gen, String eventName, String subEventName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        STRINGS.setOpaque(tagNames, i, subEventName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 10L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void attachTag(long gen, String tagName, long tagId) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(genOps, i, gen + 12L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void attachKeyedTag(long gen, String name, long value) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        LONGS.setOpaque(tagIds, i, value);
        LONGS.setOpaque(genOps, i, gen + 14L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void attachKeyedTag(long gen, String name, long value0, long value1) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        LONGS.setOpaque(tagIds, i, value0);
        LONGS.setOpaque(nanoTimes, i, value1);
        LONGS.setOpaque(genOps, i, gen + 15L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    @Override
    void attachKeyedTag(long gen, String name, String value) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        STRINGS.setOpaque(taskNames, i, value);
        LONGS.setOpaque(genOps, i, gen + 13L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void resetForThread() {
        if (this.ref.threadInfo().isTerminated()) {
            Storage.unregisterMarkHolder((MarkHolder)this);
        }
        if (!this.ref.threadInfo().isCurrentThread()) {
            return;
        }
        HiddenClassVarHandleMarkHolder.resetHolderForThread();
    }

    public void resetForAll() {
        if (this.ref.threadInfo().isTerminated()) {
            Storage.unregisterMarkHolder((MarkHolder)this);
        }
        if (!this.ref.threadInfo().isCurrentThread()) {
            return;
        }
        HiddenClassVarHandleMarkHolder.resetHolderForThread();
    }

    public List<MarkList> read() {
        ThreadInfo threadInfo = this.ref.threadInfo();
        List<Mark> marks = HiddenClassVarHandleMarkHolder.read(!threadInfo.isTerminated() && !threadInfo.isCurrentThread());
        if (marks.isEmpty()) {
            return Collections.emptyList();
        }
        return List.of(MarkList.newBuilder().setMarks(marks).setThreadId(this.ref.threadInfo().getId()).setThreadName(this.ref.threadInfo().getName()).setMarkRecorderId(this.ref.markRecorderId()).build());
    }

    public int maxMarks() {
        return 32768;
    }

    static void resetHolderForThread() {
        Arrays.fill(taskNames, null);
        Arrays.fill(tagNames, null);
        Arrays.fill(tagIds, 0L);
        Arrays.fill(nanoTimes, 0L);
        Arrays.fill(genOps, 0L);
        IDX.setRelease(0L);
        VarHandle.storeStoreFence();
    }

    static List<Mark> read(boolean concurrentWrites) {
        String[] localTaskNames = new String[2117564857];
        String[] localTagNames = new String[2117564857];
        long[] localTagIds = new long[2117564857];
        long[] localNanoTimes = new long[2117564857];
        long[] localGenOps = new long[2117564857];
        long startIdx = IDX.getOpaque();
        VarHandle.loadLoadFence();
        int size = (int)Math.min(startIdx, 2117564857L);
        for (int i = 0; i < size; ++i) {
            localTaskNames[i] = STRINGS.getOpaque(taskNames, i);
            localTagNames[i] = STRINGS.getOpaque(tagNames, i);
            localTagIds[i] = LONGS.getOpaque(tagIds, i);
            localNanoTimes[i] = LONGS.getOpaque(nanoTimes, i);
            localGenOps[i] = LONGS.getOpaque(genOps, i);
        }
        VarHandle.loadLoadFence();
        long endIdx = IDX.getOpaque();
        if (endIdx < startIdx) {
            throw new AssertionError();
        }
        boolean tailValid = !concurrentWrites || endIdx < 2117564856L;
        long eventsToDrop = (endIdx += !tailValid ? 1L : 0L) - startIdx;
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(size);
        int i = 0;
        while ((long)i < (long)size - eventsToDrop) {
            int readIdx = (int)(startIdx - (long)i - 1L & 0x7E3779B8L);
            long gen = localGenOps[readIdx] & 0xFFFFFFFFFFFFFF00L;
            int opVal = (int)(localGenOps[readIdx] & 0xFFL);
            switch (opVal) {
                case 3: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                }
                case 1: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 2: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 5: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx]));
                    break;
                }
                case 7: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 4: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 6: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 8: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 9: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 10: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 11: {
                    marks.addFirst(Mark.link((long)gen, (long)localTagIds[readIdx]));
                    break;
                }
                case 12: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 13: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 14: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 15: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx], (long)localNanoTimes[readIdx]));
                    break;
                }
                default: {
                    throw new ConcurrentModificationException("Read of storage was not threadsafe " + opVal);
                }
            }
            ++i;
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    static {
        try {
            IDX = MethodHandles.lookup().findStaticVarHandle(HiddenClassVarHandleMarkHolder.class, "idx", Long.TYPE);
            STRINGS = MethodHandles.arrayElementVarHandle(String[].class);
            LONGS = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if ((HiddenClassVarHandleMarkHolder.maxEvents() - 1 & HiddenClassVarHandleMarkHolder.maxEvents()) != 0) {
            throw new IllegalArgumentException(HiddenClassVarHandleMarkHolder.maxEvents() + " is not a power of two");
        }
        if (HiddenClassVarHandleMarkHolder.maxEvents() <= 0) {
            throw new IllegalArgumentException(HiddenClassVarHandleMarkHolder.maxEvents() + " is not positive");
        }
        if ((long)(HiddenClassVarHandleMarkHolder.maxEvents() - 1) != HiddenClassVarHandleMarkHolder.maxEventsMask()) {
            throw new IllegalArgumentException(HiddenClassVarHandleMarkHolder.maxEvents() + " doesn't match mask " + HiddenClassVarHandleMarkHolder.maxEventsMask());
        }
        taskNames = new String[2117564857];
        tagNames = new String[2117564857];
        tagIds = new long[2117564857];
        nanoTimes = new long[2117564857];
        genOps = new long[2117564857];
    }
}

