/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java15;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

final class HiddenClassVarHandleMarkHolder
extends MarkHolder {
    private static final long GEN_MASK = 255L;
    private static final long START_OP = 1L;
    private static final long START_S_OP = 2L;
    private static final long START_T_OP = 3L;
    private static final long STOP_OP = 4L;
    private static final long STOP_V_OP = 5L;
    private static final long STOP_T_OP = 6L;
    private static final long STOP_S_OP = 7L;
    private static final long EVENT_OP = 8L;
    private static final long EVENT_T_OP = 9L;
    private static final long EVENT_S_OP = 10L;
    private static final long LINK_OP = 11L;
    private static final long ATTACH_T_OP = 12L;
    private static final long ATTACH_SS_OP = 13L;
    private static final long ATTACH_SN_OP = 14L;
    private static final long ATTACH_SNN_OP = 15L;
    private static final VarHandle IDX;
    private static final VarHandle STRINGS;
    private static final VarHandle LONGS;
    static final int MAX_EVENTS = 2117564857;
    static final long MAX_EVENTS_MASK = 2117564856L;
    private static volatile long idx;
    private static final String[] taskNames;
    private static final String[] tagNames;
    private static final long[] tagIds;
    private static final long[] nanoTimes;
    private static final long[] genOps;

    HiddenClassVarHandleMarkHolder() {
    }

    public void start(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 3L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void start(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 1L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void start(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, subTaskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 2L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void link(long gen, long linkId) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        LONGS.setOpaque(tagIds, i, linkId);
        LONGS.setOpaque(genOps, i, gen + 11L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 5L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 6L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 4L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, String taskName, String subTaskName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, taskName);
        STRINGS.setOpaque(tagNames, i, subTaskName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 7L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, String eventName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 9L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, String eventName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 8L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, String eventName, String subEventName, long nanoTime) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(taskNames, i, eventName);
        STRINGS.setOpaque(tagNames, i, subEventName);
        LONGS.setOpaque(nanoTimes, i, nanoTime);
        LONGS.setOpaque(genOps, i, gen + 10L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void attachTag(long gen, String tagName, long tagId) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, tagName);
        LONGS.setOpaque(tagIds, i, tagId);
        LONGS.setOpaque(genOps, i, gen + 12L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void attachKeyedTag(long gen, String name, long value) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        LONGS.setOpaque(tagIds, i, value);
        LONGS.setOpaque(genOps, i, gen + 14L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void attachKeyedTag(long gen, String name, long value0, long value1) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        LONGS.setOpaque(tagIds, i, value0);
        LONGS.setOpaque(nanoTimes, i, value1);
        LONGS.setOpaque(genOps, i, gen + 15L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void attachKeyedTag(long gen, String name, String value) {
        long localIdx = IDX.get();
        int i = (int)(localIdx & 0x7E3779B8L);
        STRINGS.setOpaque(tagNames, i, name);
        STRINGS.setOpaque(taskNames, i, value);
        LONGS.setOpaque(genOps, i, gen + 13L);
        IDX.setRelease(localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void resetForTest() {
        Arrays.fill(taskNames, null);
        Arrays.fill(tagNames, null);
        Arrays.fill(tagIds, 0L);
        Arrays.fill(nanoTimes, 0L);
        Arrays.fill(genOps, 0L);
        IDX.setRelease(0L);
        VarHandle.storeStoreFence();
    }

    public List<Mark> read(boolean concurrentWrites) {
        String[] localTaskNames = new String[2117564857];
        String[] localTagNames = new String[2117564857];
        long[] localTagIds = new long[2117564857];
        long[] localNanoTimes = new long[2117564857];
        long[] localGenOps = new long[2117564857];
        long startIdx = IDX.getOpaque();
        VarHandle.loadLoadFence();
        int size = (int)Math.min(startIdx, 2117564857L);
        for (int i = 0; i < size; ++i) {
            localTaskNames[i] = STRINGS.getOpaque(taskNames, i);
            localTagNames[i] = STRINGS.getOpaque(tagNames, i);
            localTagIds[i] = LONGS.getOpaque(tagIds, i);
            localNanoTimes[i] = LONGS.getOpaque(nanoTimes, i);
            localGenOps[i] = LONGS.getOpaque(genOps, i);
        }
        VarHandle.loadLoadFence();
        long endIdx = IDX.getOpaque();
        if (endIdx < startIdx) {
            throw new AssertionError();
        }
        boolean tailValid = !concurrentWrites || endIdx < 2117564856L;
        long eventsToDrop = (endIdx += !tailValid ? 1L : 0L) - startIdx;
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(size);
        int i = 0;
        while ((long)i < (long)size - eventsToDrop) {
            int readIdx = (int)(startIdx - (long)i - 1L & 0x7E3779B8L);
            long gen = localGenOps[readIdx] & 0xFFFFFFFFFFFFFF00L;
            int opVal = (int)(localGenOps[readIdx] & 0xFFL);
            switch (opVal) {
                case 3: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                }
                case 1: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 2: {
                    marks.addFirst(Mark.taskStart((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 5: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx]));
                    break;
                }
                case 7: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 4: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 6: {
                    marks.addFirst(Mark.taskEnd((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 8: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 9: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 10: {
                    marks.addFirst(Mark.event((long)gen, (long)localNanoTimes[readIdx], (String)localTaskNames[readIdx], (String)localTagNames[readIdx]));
                    break;
                }
                case 11: {
                    marks.addFirst(Mark.link((long)gen, (long)localTagIds[readIdx]));
                    break;
                }
                case 12: {
                    marks.addFirst(Mark.tag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 13: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (String)localTaskNames[readIdx]));
                    break;
                }
                case 14: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx]));
                    break;
                }
                case 15: {
                    marks.addFirst(Mark.keyedTag((long)gen, (String)localTagNames[readIdx], (long)localTagIds[readIdx], (long)localNanoTimes[readIdx]));
                    break;
                }
                default: {
                    throw new ConcurrentModificationException("Read of storage was not threadsafe " + opVal);
                }
            }
            ++i;
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    public int maxMarks() {
        return 2117564857;
    }

    static {
        try {
            IDX = MethodHandles.lookup().findStaticVarHandle(HiddenClassVarHandleMarkHolder.class, "idx", Long.TYPE);
            STRINGS = MethodHandles.arrayElementVarHandle(String[].class);
            LONGS = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            int maxEvents = (Integer)HiddenClassVarHandleMarkHolder.class.getDeclaredField("MAX_EVENTS").get(null);
            if ((maxEvents - 1 & maxEvents) != 0) {
                throw new IllegalArgumentException(maxEvents + " is not a power of two");
            }
            if (maxEvents <= 0) {
                throw new IllegalArgumentException(maxEvents + " is not positive");
            }
            long maxEventsMask = (Long)HiddenClassVarHandleMarkHolder.class.getDeclaredField("MAX_EVENTS_MASK").get(null);
            if ((long)(maxEvents - 1) != maxEventsMask) {
                throw new IllegalArgumentException(maxEvents + " doesn't match mask " + maxEventsMask);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        taskNames = new String[2117564857];
        tagNames = new String[2117564857];
        tagIds = new long[2117564857];
        nanoTimes = new long[2117564857];
        genOps = new long[2117564857];
    }
}

