/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.ThreadRef;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentThreadLocal<T> {
    private final ConcurrentMap<ThreadRef, T> refs = new ConcurrentHashMap<ThreadRef, T>();
    private final ReferenceQueue<Thread> queue = new ReferenceQueue();

    public T get() {
        T value = ThreadRef.get(this.refs);
        if (value != null) {
            return value;
        }
        value = this.initialValueInternal();
        if (value != null) {
            this.refs.put(ThreadRef.newRef(this.queue), value);
        }
        return value;
    }

    public void remove() {
        ThreadRef.removeAndClearRef(this.refs);
        this.drainQueue();
    }

    public void set(T value) {
        ThreadRef.removeAndClearRef(this.refs);
        this.refs.put(ThreadRef.newRef(this.queue), value);
    }

    protected T initialValue() {
        return null;
    }

    private T initialValueInternal() {
        this.drainQueue();
        return this.initialValue();
    }

    private void drainQueue() {
        Reference<Thread> ref = this.queue.poll();
        if (ref == null) {
            return;
        }
        this.drainQueue(ref);
    }

    private void drainQueue(Reference<? extends Thread> ref) {
        do {
            this.refs.remove((ThreadRef)ref);
        } while ((ref = this.queue.poll()) != null);
    }
}

