/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.Marker;
import io.perfmark.impl.SecretPerfMarkImpl;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class Mark {
    public static final String NO_TAG_NAME = "";
    public static final long NO_TAG_ID = SecretPerfMarkImpl.PerfMarkImpl.NO_TAG_ID;
    public static final long NO_LINK_ID = SecretPerfMarkImpl.PerfMarkImpl.NO_LINK_ID;
    public static final long NO_NANOTIME = 0L;
    @Nullable
    private final String taskName;
    @Nullable
    private final Marker marker;
    @Nullable
    private final String tagName;
    private final long tagId;
    private final long linkId;
    private final long nanoTime;
    private final long generation;
    private final Operation operation;

    public static Mark create(String taskName, @Nullable String tagName, long tagId, long nanoTime, long generation, Operation operation) {
        return new Mark(taskName, tagName, tagId, nanoTime, generation, operation);
    }

    public static Mark create(Marker marker, @Nullable String tagName, long tagId, long nanoTime, long generation, Operation operation) {
        return new Mark(marker, tagName, tagId, nanoTime, generation, operation);
    }

    private Mark(Object taskNameOrMarker, @Nullable String tagName, long tagId, long nanoTime, long generation, Operation operation) {
        this.operation = Mark.checkNotNull(operation, "operation");
        if (operation == Operation.NONE) {
            throw new IllegalArgumentException("bad operation");
        }
        if (taskNameOrMarker instanceof Marker) {
            this.marker = (Marker)taskNameOrMarker;
            this.taskName = ((Marker)taskNameOrMarker).getTaskName();
        } else if (taskNameOrMarker instanceof String) {
            this.marker = null;
            this.taskName = (String)taskNameOrMarker;
        } else {
            throw new IllegalArgumentException("wrong marker type " + taskNameOrMarker);
        }
        switch (operation) {
            case TASK_START: 
            case TASK_END: 
            case EVENT: {
                this.tagName = tagName;
                this.tagId = tagId;
                break;
            }
            case TASK_NOTAG_START: 
            case TASK_NOTAG_END: 
            case EVENT_NOTAG: 
            case LINK: {
                this.tagName = NO_TAG_NAME;
                this.tagId = NO_TAG_ID;
                break;
            }
            default: {
                throw new AssertionError((Object)String.valueOf((Object)operation));
            }
        }
        if (operation == Operation.LINK) {
            this.nanoTime = 0L;
            this.linkId = tagId;
        } else {
            this.nanoTime = nanoTime;
            this.linkId = NO_LINK_ID;
        }
        this.generation = generation;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public long getGeneration() {
        return this.generation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Nullable
    public String getTagName() {
        return this.tagName;
    }

    public long getTagId() {
        return this.tagId;
    }

    @Nullable
    public Marker getMarker() {
        return this.marker;
    }

    @Nullable
    public String getTaskName() {
        return this.taskName;
    }

    public long getLinkId() {
        return this.linkId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Mark)) {
            return false;
        }
        Mark that = (Mark)obj;
        return Mark.equal(this.taskName, that.taskName) && Mark.equal(this.marker, that.marker) && Mark.equal(this.tagName, that.tagName) && this.tagId == that.tagId && this.linkId == that.linkId && this.nanoTime == that.nanoTime && this.operation == that.operation;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.taskName, this.tagName, this.tagId, this.linkId, this.marker, this.nanoTime, this.operation});
    }

    public String toString() {
        return "Mark{taskName=" + this.taskName + ", tagName=" + this.tagName + ", tagId=" + this.tagId + ", linkId=" + this.linkId + ", marker=" + this.marker + ", nanoTime=" + this.nanoTime + ", generation=" + this.generation + ", operation=" + (Object)((Object)this.operation) + "}";
    }

    private static <T> T checkNotNull(T t, String name) {
        if (t == null) {
            throw new NullPointerException(name + " is null");
        }
        return t;
    }

    static <T> boolean equal(T a, T b) {
        return a == b || a.equals(b);
    }

    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation NONE = new Operation();
        public static final /* enum */ Operation TASK_START = new Operation();
        public static final /* enum */ Operation TASK_NOTAG_START = new Operation();
        public static final /* enum */ Operation TASK_END = new Operation();
        public static final /* enum */ Operation TASK_NOTAG_END = new Operation();
        public static final /* enum */ Operation EVENT = new Operation();
        public static final /* enum */ Operation EVENT_NOTAG = new Operation();
        public static final /* enum */ Operation LINK = new Operation();
        private static final Operation[] values;
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        public static Operation valueOf(int ordinal) {
            return values[ordinal];
        }

        static {
            $VALUES = new Operation[]{NONE, TASK_START, TASK_NOTAG_START, TASK_END, TASK_NOTAG_END, EVENT, EVENT_NOTAG, LINK};
            values = Operation.values();
            assert (values.length <= 256);
        }
    }
}

