/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark;

import com.google.errorprone.annotations.CompileTimeConstant;
import io.perfmark.PerfMark;
import io.perfmark.Tag;
import java.io.Closeable;

public abstract class PerfMarkCloseable
implements Closeable {
    static final PerfMarkCloseable NOOP = new NoopAutoCloseable();

    @Override
    public abstract void close();

    PerfMarkCloseable() {
    }

    static final class TaskAutoCloseable
    extends PerfMarkCloseable {
        private final String taskName;

        @Override
        public void close() {
            PerfMark.stopTaskNonConstant(this.taskName);
        }

        TaskAutoCloseable(@CompileTimeConstant String taskName) {
            this.taskName = taskName;
        }
    }

    static final class TaskTagAutoCloseable
    extends PerfMarkCloseable {
        private final String taskName;
        private final Tag tag;

        @Override
        public void close() {
            PerfMark.stopTaskNonConstant(this.taskName, this.tag);
        }

        TaskTagAutoCloseable(@CompileTimeConstant String taskName, Tag tag) {
            this.taskName = taskName;
            this.tag = tag;
        }
    }

    private static final class NoopAutoCloseable
    extends PerfMarkCloseable {
        @Override
        public void close() {
        }

        NoopAutoCloseable() {
        }
    }
}

