/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark;

import com.google.errorprone.annotations.CompileTimeConstant;
import io.perfmark.Link;
import io.perfmark.NoopGenerator;
import io.perfmark.PerfMarkCloseable;
import io.perfmark.PerfMarkStorage;
import io.perfmark.Tag;
import io.perfmark.impl.Generator;
import io.perfmark.impl.Marker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerfMark {
    private static final long INCREMENT = 256L;
    static final String START_ENABLED_PROPERTY = "io.perfmark.PerfMark.startEnabled";
    static final List<String> FALLBACK_GENERATORS;
    static final long initNanoTime;
    private static final Generator generator;
    private static final Logger logger;
    private static long actualGeneration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> List<T> getLoadable(List<? super Throwable> errors, Class<T> clz, List<? extends String> fallbackClassNames, ClassLoader cl) {
        LinkedHashMap<Class<T>, T> loadables = new LinkedHashMap<Class<T>, T>();
        ArrayList<ServiceConfigurationError> serviceLoaderErrors = new ArrayList<ServiceConfigurationError>();
        try {
            ServiceLoader<T> loader = ServiceLoader.load(clz, cl);
            Iterator<T> iterator = loader.iterator();
            for (int i = 0; i < 10 && serviceLoaderErrors.size() < 10; ++i) {
                try {
                    if (iterator.hasNext()) {
                        T next = iterator.next();
                        Class<T> subClz = next.getClass().asSubclass(clz);
                        if (loadables.containsKey(subClz)) continue;
                        loadables.put(subClz, next);
                        continue;
                    }
                    break;
                }
                catch (ServiceConfigurationError sce) {
                    Throwable last;
                    if (!serviceLoaderErrors.isEmpty() && PerfMark.errorsEqual(sce, last = (Throwable)serviceLoaderErrors.get(serviceLoaderErrors.size() - 1))) continue;
                    serviceLoaderErrors.add(sce);
                }
            }
        }
        catch (ServiceConfigurationError sce) {
            serviceLoaderErrors.add(sce);
        }
        finally {
            errors.addAll(serviceLoaderErrors);
        }
        for (String string : fallbackClassNames) {
            try {
                Class<?> fallbackClz = Class.forName(string, true, cl);
                if (loadables.containsKey(fallbackClz)) continue;
                Class<T> subClz = fallbackClz.asSubclass(clz);
                loadables.put(subClz, subClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        return Collections.unmodifiableList(new ArrayList(loadables.values()));
    }

    public static synchronized void setEnabled(boolean value) {
        PerfMark.logEnabledChange(value, PerfMark.setEnabledQuiet(value));
    }

    private static synchronized void logEnabledChange(boolean value, boolean success) {
        if (success && logger.isLoggable(Level.FINE)) {
            logger.fine((value ? "Enabling" : "Disabling") + " PerfMark recorder");
        }
    }

    private static synchronized boolean setEnabledQuiet(boolean value) {
        if (PerfMark.isEnabled(actualGeneration) == value) {
            return false;
        }
        if (actualGeneration == -512L) {
            return false;
        }
        generator.setGeneration(actualGeneration += 256L);
        return true;
    }

    static synchronized long getActualGeneration() {
        return actualGeneration;
    }

    public static void startTask(@CompileTimeConstant String taskName, Tag tag) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.startAnyways(gen, taskName, tag);
    }

    public static void startTask(@CompileTimeConstant String taskName) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.startAnyways(gen, taskName);
    }

    public static void event(@CompileTimeConstant String eventName, Tag tag) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.eventAnyways(gen, eventName, tag);
    }

    public static void event(@CompileTimeConstant String eventName) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.eventAnyways(gen, eventName);
    }

    public static void stopTask(@CompileTimeConstant String taskName, Tag tag) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.stopAnyways(gen, taskName, tag);
    }

    public static void stopTask(@CompileTimeConstant String taskName) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.stopAnyways(gen, taskName);
    }

    public static PerfMarkCloseable record(@CompileTimeConstant String taskName, Tag tag) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return PerfMarkCloseable.NOOP;
        }
        PerfMarkStorage.startAnyways(gen, taskName, tag);
        return new PerfMarkCloseable.TaskTagAutoCloseable(taskName, tag);
    }

    public static PerfMarkCloseable record(@CompileTimeConstant String taskName) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return PerfMarkCloseable.NOOP;
        }
        PerfMarkStorage.startAnyways(gen, taskName);
        return new PerfMarkCloseable.TaskAutoCloseable(taskName);
    }

    public static Tag createTag() {
        return Tag.NO_TAG;
    }

    public static Tag createTag(long id) {
        if (!PerfMark.isEnabled(PerfMark.getGen())) {
            return Tag.NO_TAG;
        }
        return new Tag(id);
    }

    public static Tag createTag(String name) {
        if (!PerfMark.isEnabled(PerfMark.getGen())) {
            return Tag.NO_TAG;
        }
        return new Tag(name);
    }

    public static Tag createTag(String name, long id) {
        if (!PerfMark.isEnabled(PerfMark.getGen())) {
            return Tag.NO_TAG;
        }
        return new Tag(name, id);
    }

    public static Link link() {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return Link.NONE;
        }
        long inboundLinkId = Link.linkIdAlloc.incrementAndGet();
        PerfMarkStorage.linkAnyways(gen, inboundLinkId, Marker.NONE);
        return new Link(inboundLinkId);
    }

    static void link(long linkId) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.linkAnyways(gen, -linkId, Marker.NONE);
    }

    static void stopTaskNonConstant(String taskName, Tag tag) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.stopAnyways(gen, taskName, tag);
    }

    static void stopTaskNonConstant(String taskName) {
        long gen = PerfMark.getGen();
        if (!PerfMark.isEnabled(gen)) {
            return;
        }
        PerfMarkStorage.stopAnyways(gen, taskName);
    }

    private PerfMark() {
    }

    static long getGen() {
        return generator.getGeneration();
    }

    static boolean isEnabled(long gen) {
        return (gen >>> 8 & 1L) != 0L;
    }

    private static boolean errorsEqual(Throwable t1, Throwable t2) {
        String msg2;
        String msg1;
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (t1.getClass() == t2.getClass() && ((msg1 = t1.getMessage()) == (msg2 = t2.getMessage()) || msg1 != null && msg1.equals(msg2)) && Arrays.equals(t1.getStackTrace(), t2.getStackTrace())) {
            return PerfMark.errorsEqual(t1.getCause(), t2.getCause());
        }
        return false;
    }

    static {
        Level level;
        FALLBACK_GENERATORS = Collections.unmodifiableList(Arrays.asList("io.perfmark.java7.SecretMethodHandleGenerator$MethodHandleGenerator", "io.perfmark.java9.SecretVarHandleGenerator$VarHandleGenerator", "io.perfmark.java6.SecretVolatileGenerator$VolatileGenerator"));
        initNanoTime = System.nanoTime();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        List<Generator> generators = PerfMark.getLoadable(errors, Generator.class, FALLBACK_GENERATORS, PerfMark.class.getClassLoader());
        if (generators.isEmpty()) {
            generator = new NoopGenerator();
            level = Level.WARNING;
        } else {
            generator = generators.get(0);
            level = Level.FINE;
        }
        boolean startEnabled = false;
        try {
            startEnabled = Boolean.parseBoolean(System.getProperty(START_ENABLED_PROPERTY, "false"));
        }
        catch (RuntimeException e) {
            errors.add(e);
        }
        catch (Error e) {
            errors.add(e);
        }
        boolean success = PerfMark.setEnabledQuiet(startEnabled);
        logger = Logger.getLogger(PerfMark.class.getName());
        logger.log(level, "Using {0}", new Object[]{generator.getClass()});
        PerfMark.logEnabledChange(startEnabled, success);
        for (Throwable error : errors) {
            logger.log(level, "Error encountered loading generator", error);
        }
    }

    static final class PackageAccess {
        private PackageAccess() {
            throw new AssertionError((Object)"nope");
        }

        public static final class Public {
            public static void startTask(Marker marker, Tag tag) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.startAnyways(gen, marker, tag);
            }

            public static void startTask(Marker marker) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.startAnyways(gen, marker);
            }

            public static void stopTask(Marker marker, Tag tag) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.stopAnyways(gen, marker, tag);
            }

            public static void stopTask(Marker marker) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.stopAnyways(gen, marker);
            }

            public static void event(Marker marker, Tag tag) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.eventAnyways(gen, marker, tag);
            }

            public static void event(Marker marker) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.eventAnyways(gen, marker);
            }

            public static Link link(Marker marker) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return Link.NONE;
                }
                long inboundLinkId = Link.linkIdAlloc.incrementAndGet();
                PerfMarkStorage.linkAnyways(gen, inboundLinkId, marker);
                return new Link(inboundLinkId);
            }

            public static void link(long linkId, Marker marker) {
                long gen = PerfMark.getGen();
                if (!PerfMark.isEnabled(gen)) {
                    return;
                }
                PerfMarkStorage.linkAnyways(gen, -linkId, marker);
            }

            private Public() {
                throw new AssertionError((Object)"nope");
            }
        }
    }
}

