/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.orangebeard.client.entity.Attribute;
import io.orangebeard.client.entity.DateSerializer;
import io.orangebeard.client.entity.TestItemType;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.UUID;

public class StartTestItem {
    @JsonProperty(value="launchUuid")
    private UUID testRunUUID;
    private TestItemType type;
    private String name;
    private String codeRef;
    private String description;
    @JsonSerialize(using=DateSerializer.class)
    private LocalDateTime startTime;
    private Set<Attribute> attributes;

    public StartTestItem(UUID testRunUUID, String name, TestItemType type, String description, Set<Attribute> attributes) {
        this.testRunUUID = testRunUUID;
        this.name = name;
        this.type = type;
        this.description = description;
        this.startTime = LocalDateTime.now();
        this.attributes = attributes;
    }

    public StartTestItem(UUID testRunUUID, String name, TestItemType type) {
        this.testRunUUID = testRunUUID;
        this.name = name;
        this.type = type;
        this.startTime = LocalDateTime.now();
    }

    public static StartTestItemBuilder builder() {
        return new StartTestItemBuilder();
    }

    public UUID getTestRunUUID() {
        return this.testRunUUID;
    }

    public TestItemType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getCodeRef() {
        return this.codeRef;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartTestItem)) {
            return false;
        }
        StartTestItem other = (StartTestItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$testRunUUID = this.getTestRunUUID();
        UUID other$testRunUUID = other.getTestRunUUID();
        if (this$testRunUUID == null ? other$testRunUUID != null : !((Object)this$testRunUUID).equals(other$testRunUUID)) {
            return false;
        }
        TestItemType this$type = this.getType();
        TestItemType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$codeRef = this.getCodeRef();
        String other$codeRef = other.getCodeRef();
        if (this$codeRef == null ? other$codeRef != null : !this$codeRef.equals(other$codeRef)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Set<Attribute> this$attributes = this.getAttributes();
        Set<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StartTestItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $testRunUUID = this.getTestRunUUID();
        result = result * 59 + ($testRunUUID == null ? 43 : ((Object)$testRunUUID).hashCode());
        TestItemType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $codeRef = this.getCodeRef();
        result = result * 59 + ($codeRef == null ? 43 : $codeRef.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Set<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public StartTestItem() {
    }

    public StartTestItem(UUID testRunUUID, TestItemType type, String name, String codeRef, String description, LocalDateTime startTime, Set<Attribute> attributes) {
        this.testRunUUID = testRunUUID;
        this.type = type;
        this.name = name;
        this.codeRef = codeRef;
        this.description = description;
        this.startTime = startTime;
        this.attributes = attributes;
    }

    public static class StartTestItemBuilder {
        private UUID testRunUUID;
        private TestItemType type;
        private String name;
        private String codeRef;
        private String description;
        private LocalDateTime startTime;
        private Set<Attribute> attributes;

        StartTestItemBuilder() {
        }

        @JsonProperty(value="launchUuid")
        public StartTestItemBuilder testRunUUID(UUID testRunUUID) {
            this.testRunUUID = testRunUUID;
            return this;
        }

        public StartTestItemBuilder type(TestItemType type) {
            this.type = type;
            return this;
        }

        public StartTestItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StartTestItemBuilder codeRef(String codeRef) {
            this.codeRef = codeRef;
            return this;
        }

        public StartTestItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StartTestItemBuilder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public StartTestItemBuilder attributes(Set<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public StartTestItem build() {
            return new StartTestItem(this.testRunUUID, this.type, this.name, this.codeRef, this.description, this.startTime, this.attributes);
        }

        public String toString() {
            return "StartTestItem.StartTestItemBuilder(testRunUUID=" + this.testRunUUID + ", type=" + (Object)((Object)this.type) + ", name=" + this.name + ", codeRef=" + this.codeRef + ", description=" + this.description + ", startTime=" + this.startTime + ", attributes=" + this.attributes + ")";
        }
    }
}

