/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.orangebeard.client.entity.DateSerializer;
import io.orangebeard.client.entity.LogLevel;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.UUID;

public class Attachment {
    @JsonProperty(value="launchUuid")
    private UUID testRunUUID;
    private UUID itemUuid;
    @JsonProperty(value="level")
    private LogLevel logLevel;
    private String message;
    @JsonProperty(value="file")
    private File file;
    @JsonSerialize(using=DateSerializer.class)
    private LocalDateTime time;

    public Attachment(UUID testRunUUID, UUID testItemUUID, LogLevel logLevel, String fileName, File file) {
        this.testRunUUID = testRunUUID;
        this.itemUuid = testItemUUID;
        this.logLevel = logLevel;
        this.message = fileName;
        this.time = LocalDateTime.now();
        this.file = file;
    }

    public static AttachmentBuilder builder() {
        return new AttachmentBuilder();
    }

    public UUID getTestRunUUID() {
        return this.testRunUUID;
    }

    public UUID getItemUuid() {
        return this.itemUuid;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public File getFile() {
        return this.file;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$testRunUUID = this.getTestRunUUID();
        UUID other$testRunUUID = other.getTestRunUUID();
        if (this$testRunUUID == null ? other$testRunUUID != null : !((Object)this$testRunUUID).equals(other$testRunUUID)) {
            return false;
        }
        UUID this$itemUuid = this.getItemUuid();
        UUID other$itemUuid = other.getItemUuid();
        if (this$itemUuid == null ? other$itemUuid != null : !((Object)this$itemUuid).equals(other$itemUuid)) {
            return false;
        }
        LogLevel this$logLevel = this.getLogLevel();
        LogLevel other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $testRunUUID = this.getTestRunUUID();
        result = result * 59 + ($testRunUUID == null ? 43 : ((Object)$testRunUUID).hashCode());
        UUID $itemUuid = this.getItemUuid();
        result = result * 59 + ($itemUuid == null ? 43 : ((Object)$itemUuid).hashCode());
        LogLevel $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public Attachment() {
    }

    public Attachment(UUID testRunUUID, UUID itemUuid, LogLevel logLevel, String message, File file, LocalDateTime time) {
        this.testRunUUID = testRunUUID;
        this.itemUuid = itemUuid;
        this.logLevel = logLevel;
        this.message = message;
        this.file = file;
        this.time = time;
    }

    public static class AttachmentBuilder {
        private UUID testRunUUID;
        private UUID itemUuid;
        private LogLevel logLevel;
        private String message;
        private File file;
        private LocalDateTime time;

        AttachmentBuilder() {
        }

        @JsonProperty(value="launchUuid")
        public AttachmentBuilder testRunUUID(UUID testRunUUID) {
            this.testRunUUID = testRunUUID;
            return this;
        }

        public AttachmentBuilder itemUuid(UUID itemUuid) {
            this.itemUuid = itemUuid;
            return this;
        }

        @JsonProperty(value="level")
        public AttachmentBuilder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public AttachmentBuilder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="file")
        public AttachmentBuilder file(File file) {
            this.file = file;
            return this;
        }

        public AttachmentBuilder time(LocalDateTime time) {
            this.time = time;
            return this;
        }

        public Attachment build() {
            return new Attachment(this.testRunUUID, this.itemUuid, this.logLevel, this.message, this.file, this.time);
        }

        public String toString() {
            return "Attachment.AttachmentBuilder(testRunUUID=" + this.testRunUUID + ", itemUuid=" + this.itemUuid + ", logLevel=" + (Object)((Object)this.logLevel) + ", message=" + this.message + ", file=" + this.file + ", time=" + this.time + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class File {
        private final String name;
        @JsonIgnore
        private final byte[] content;
        @JsonIgnore
        private final String contentType;

        public File(java.io.File file) throws IOException {
            this.name = file.getName();
            this.content = Files.readAllBytes(file.toPath());
            this.contentType = Files.probeContentType(file.toPath());
        }

        public String getName() {
            return this.name;
        }

        public byte[] getContent() {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public File(String name, byte[] content, String contentType) {
            this.name = name;
            this.content = content;
            this.contentType = contentType;
        }
    }
}

