/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client;

import io.orangebeard.client.OrangebeardClient;
import io.orangebeard.client.entity.Attachment;
import java.util.Collections;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractClient
implements OrangebeardClient {
    protected final UUID uuid;

    public AbstractClient(UUID uuid) {
        this.uuid = uuid;
    }

    protected HttpHeaders getAuthorizationHeaders(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    protected HttpEntity<LinkedMultiValueMap<String, Object>> getMultipartLogRequest(Attachment attachmentLogItem) {
        LinkedMultiValueMap filePartHeaders = new LinkedMultiValueMap();
        filePartHeaders.add((Object)"Content-Disposition", (Object)String.format("form-data; name=\"file\"; filename=\"%s\"", attachmentLogItem.getFile().getName()));
        filePartHeaders.add((Object)"Content-Type", (Object)attachmentLogItem.getFile().getContentType());
        byte[] fileContents = attachmentLogItem.getFile().getContent();
        HttpEntity filePart = new HttpEntity((Object)fileContents, (MultiValueMap)filePartHeaders);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"json_request_part", Collections.singletonList(attachmentLogItem));
        parts.add((Object)"file", (Object)filePart);
        HttpHeaders headers = this.getAuthorizationHeaders(this.uuid.toString());
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        return new HttpEntity((Object)parts, (MultiValueMap)headers);
    }
}

