/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.JsonEncoding;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.common.ValueType;
import java.util.Objects;

final class ValueLong
implements Value<Long> {
    private final long value;

    private ValueLong(long value) {
        this.value = value;
    }

    static Value<Long> create(long value) {
        return new ValueLong(value);
    }

    @Override
    public ValueType getType() {
        return ValueType.LONG;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        JsonEncoding.append(sb, this);
        return sb.toString();
    }

    public String toString() {
        return "ValueLong{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

