/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.JsonEncoding;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.common.ValueType;
import java.util.Objects;

final class ValueBoolean
implements Value<Boolean> {
    private final boolean value;

    private ValueBoolean(boolean value) {
        this.value = value;
    }

    static Value<Boolean> create(boolean value) {
        return new ValueBoolean(value);
    }

    @Override
    public ValueType getType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder();
        JsonEncoding.append(sb, this);
        return sb.toString();
    }

    public String toString() {
        return "ValueBoolean{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }
}

