/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.ArrayBackedAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.common.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public Attributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedAttributes(this.data.toArray());
        }
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put((AttributeKey<T>)key, (T)Long.valueOf(value));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key, @Nullable T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (key.getType() == AttributeType.VALUE && value instanceof Value) {
            this.putValue(key, (Value)value);
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    private void putValue(AttributeKey<?> key, Value<?> valueObj) {
        String keyName = key.getKey();
        switch (valueObj.getType()) {
            case STRING: {
                this.put(AttributeKey.stringKey(keyName), (T)((String)valueObj.getValue()));
                return;
            }
            case LONG: {
                this.put((AttributeKey<T>)AttributeKey.longKey(keyName), (T)((Long)valueObj.getValue()));
                return;
            }
            case DOUBLE: {
                this.put(AttributeKey.doubleKey(keyName), (T)((Double)valueObj.getValue()));
                return;
            }
            case BOOLEAN: {
                this.put(AttributeKey.booleanKey(keyName), (T)((Boolean)valueObj.getValue()));
                return;
            }
            case ARRAY: {
                List arrayValues = (List)valueObj.getValue();
                AttributeType attributeType = ArrayBackedAttributesBuilder.attributeType(arrayValues);
                switch (attributeType) {
                    case STRING_ARRAY: {
                        ArrayList<String> strings = new ArrayList<String>(arrayValues.size());
                        for (Value v : arrayValues) {
                            strings.add((String)v.getValue());
                        }
                        this.put(AttributeKey.stringArrayKey(keyName), (T)strings);
                        return;
                    }
                    case LONG_ARRAY: {
                        ArrayList<Long> longs = new ArrayList<Long>(arrayValues.size());
                        for (Value v : arrayValues) {
                            longs.add((Long)v.getValue());
                        }
                        this.put(AttributeKey.longArrayKey(keyName), (T)longs);
                        return;
                    }
                    case DOUBLE_ARRAY: {
                        ArrayList<Double> doubles = new ArrayList<Double>(arrayValues.size());
                        for (Value v : arrayValues) {
                            doubles.add((Double)v.getValue());
                        }
                        this.put(AttributeKey.doubleArrayKey(keyName), (T)doubles);
                        return;
                    }
                    case BOOLEAN_ARRAY: {
                        ArrayList<Boolean> booleans = new ArrayList<Boolean>(arrayValues.size());
                        for (Value v : arrayValues) {
                            booleans.add((Boolean)v.getValue());
                        }
                        this.put(AttributeKey.booleanArrayKey(keyName), (T)booleans);
                        return;
                    }
                    case VALUE: {
                        this.data.add(key);
                        this.data.add(valueObj);
                        return;
                    }
                }
                throw new IllegalArgumentException("Unexpected array attribute type: " + (Object)((Object)attributeType));
            }
            case KEY_VALUE_LIST: 
            case BYTES: 
            case EMPTY: {
                this.data.add(key);
                this.data.add(valueObj);
            }
        }
    }

    private static AttributeType attributeType(List<Value<?>> arrayValues) {
        if (arrayValues.isEmpty()) {
            return AttributeType.VALUE;
        }
        ValueType elementType = arrayValues.get(0).getType();
        for (Value<?> v : arrayValues) {
            if (v.getType() == elementType) continue;
            return AttributeType.VALUE;
        }
        switch (elementType) {
            case STRING: {
                return AttributeType.STRING_ARRAY;
            }
            case LONG: {
                return AttributeType.LONG_ARRAY;
            }
            case DOUBLE: {
                return AttributeType.DOUBLE_ARRAY;
            }
            case BOOLEAN: {
                return AttributeType.BOOLEAN_ARRAY;
            }
            case ARRAY: 
            case KEY_VALUE_LIST: 
            case BYTES: 
            case EMPTY: {
                return AttributeType.VALUE;
            }
        }
        throw new IllegalArgumentException("Unsupported element type: " + (Object)((Object)elementType));
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((AttributeKey<T>)((AttributeKey)key), (T)value));
        return this;
    }

    @Override
    public <T> AttributesBuilder remove(AttributeKey<T> key) {
        if (key == null || key.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(entryKey -> key.getKey().equals(entryKey.getKey()) && key.getType().equals((Object)entryKey.getType()));
    }

    @Override
    public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof AttributeKey) || !predicate.test((AttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

