/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.common.ValueType;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ArrayBackedAttributes
extends ImmutableKeyValuePairs<AttributeKey<?>, Object>
implements Attributes {
    private static final Comparator<AttributeKey<?>> KEY_COMPARATOR_FOR_CONSTRUCTION = Comparator.comparing(AttributeKey::getKey);
    static final Attributes EMPTY = Attributes.builder().build();

    private ArrayBackedAttributes(Object[] data, Comparator<AttributeKey<?>> keyComparator) {
        super(data, keyComparator);
    }

    ArrayBackedAttributes(Object[] data) {
        super(data);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return new ArrayBackedAttributesBuilder(new ArrayList<Object>(this.data()));
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> key) {
        if (key == null) {
            return null;
        }
        if (key.getType() == AttributeType.VALUE) {
            return (T)this.getAsValue(key.getKey());
        }
        if (ArrayBackedAttributes.isArrayType(key.getType())) {
            Value<?> valueAttr;
            Object value = super.get(key);
            if (value == null && (valueAttr = this.getValueAttribute(key.getKey())) != null && ArrayBackedAttributes.isEmptyArray(valueAttr)) {
                return (T)Collections.emptyList();
            }
            return (T)value;
        }
        return (T)super.get(key);
    }

    private static boolean isArrayType(AttributeType type) {
        return type == AttributeType.STRING_ARRAY || type == AttributeType.LONG_ARRAY || type == AttributeType.DOUBLE_ARRAY || type == AttributeType.BOOLEAN_ARRAY;
    }

    @Nullable
    private Value<?> getValueAttribute(String keyName) {
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            AttributeKey currentKey = (AttributeKey)data.get(i);
            if (!currentKey.getKey().equals(keyName) || currentKey.getType() != AttributeType.VALUE) continue;
            return (Value)data.get(i + 1);
        }
        return null;
    }

    private static boolean isEmptyArray(Value<?> value) {
        if (value.getType() != ValueType.ARRAY) {
            return false;
        }
        List arrayValues = (List)value.getValue();
        return arrayValues.isEmpty();
    }

    @Nullable
    private Value<?> getAsValue(String keyName) {
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            AttributeKey currentKey = (AttributeKey)data.get(i);
            if (!currentKey.getKey().equals(keyName)) continue;
            Object value = data.get(i + 1);
            return ArrayBackedAttributes.asValue(currentKey.getType(), value);
        }
        return null;
    }

    @Nullable
    private static Value<?> asValue(AttributeType type, Object value) {
        switch (type) {
            case STRING: {
                return Value.of((String)value);
            }
            case LONG: {
                return Value.of((Long)value);
            }
            case DOUBLE: {
                return Value.of((Double)value);
            }
            case BOOLEAN: {
                return Value.of((Boolean)value);
            }
            case STRING_ARRAY: {
                List stringList = (List)value;
                Value[] stringValues = new Value[stringList.size()];
                for (int i = 0; i < stringList.size(); ++i) {
                    stringValues[i] = Value.of((String)stringList.get(i));
                }
                return Value.of(stringValues);
            }
            case LONG_ARRAY: {
                List longList = (List)value;
                Value[] longValues = new Value[longList.size()];
                for (int i = 0; i < longList.size(); ++i) {
                    longValues[i] = Value.of((Long)longList.get(i));
                }
                return Value.of(longValues);
            }
            case DOUBLE_ARRAY: {
                List doubleList = (List)value;
                Value[] doubleValues = new Value[doubleList.size()];
                for (int i = 0; i < doubleList.size(); ++i) {
                    doubleValues[i] = Value.of((Double)doubleList.get(i));
                }
                return Value.of(doubleValues);
            }
            case BOOLEAN_ARRAY: {
                List booleanList = (List)value;
                Value[] booleanValues = new Value[booleanList.size()];
                for (int i = 0; i < booleanList.size(); ++i) {
                    booleanValues[i] = Value.of((Boolean)booleanList.get(i));
                }
                return Value.of(booleanValues);
            }
            case VALUE: {
                return (Value)value;
            }
        }
        return null;
    }

    static Attributes sortAndFilterToAttributes(Object ... data) {
        for (int i = 0; i < data.length; i += 2) {
            AttributeKey key = (AttributeKey)data[i];
            if (key == null || !key.getKey().isEmpty()) continue;
            data[i] = null;
        }
        return new ArrayBackedAttributes(data, KEY_COMPARATOR_FOR_CONSTRUCTION);
    }
}

