/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.trace.BigendianEncoding;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceFlags {
    private static final byte IS_SAMPLED = 1;
    private static final byte DEFAULT = 0;
    private static final int SIZE = 1;
    private static final int BASE16_SIZE = 2;

    private TraceFlags() {
    }

    public static int getHexLength() {
        return 2;
    }

    public static byte getDefault() {
        return 0;
    }

    public static boolean isSampledFromHex(CharSequence src, int srcOffset) {
        byte b = BigendianEncoding.byteFromBase16String(src, srcOffset);
        return (b & 1) != 0;
    }

    public static byte byteFromHex(CharSequence src, int srcOffset) {
        return BigendianEncoding.byteFromBase16String(src, srcOffset);
    }

    public static byte getSampled() {
        return 1;
    }
}

