/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.internal;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.internal.Utils;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    public static final int NAME_MAX_LENGTH = 255;

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static boolean isValidMetricName(String metricName) {
        if (metricName.isEmpty() || metricName.length() > 255) {
            return false;
        }
        String pattern = "[aA-zZ][aA-zZ0-9_\\-.]*";
        return metricName.matches(pattern);
    }

    public static AttributeValue truncateToSize(AttributeValue value, int limit) {
        Utils.checkArgument(limit > 0, "attribute value limit must be positive, got %d", limit);
        if (value == null || value.getType() != AttributeValue.Type.STRING && value.getType() != AttributeValue.Type.STRING_ARRAY) {
            return value;
        }
        if (value.getType() == AttributeValue.Type.STRING_ARRAY) {
            List<String> strings = value.getStringArrayValue();
            if (strings.isEmpty()) {
                return value;
            }
            String[] newStrings = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                String string = strings.get(i);
                newStrings[i] = StringUtils.truncateToSize(string, limit);
            }
            return AttributeValue.arrayAttributeValue(newStrings);
        }
        String string = value.getStringValue();
        return string == null || string.length() <= limit ? value : AttributeValue.stringAttributeValue(string.substring(0, limit));
    }

    @Nullable
    private static String truncateToSize(@Nullable String s, int limit) {
        if (s == null || s.length() <= limit) {
            return s;
        }
        return s.substring(0, limit);
    }

    private StringUtils() {
    }
}

