/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.context.Scope;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultTracer
implements Tracer {
    private static final DefaultTracer INSTANCE = new DefaultTracer();

    public static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public Span getCurrentSpan() {
        return TracingContextUtils.getCurrentSpan();
    }

    @Override
    public Scope withSpan(Span span) {
        return TracingContextUtils.currentContextWith(span);
    }

    @Override
    public Span.Builder spanBuilder(String spanName) {
        return NoopSpanBuilder.create(spanName);
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements Span.Builder {
        private boolean isRootSpan;
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create(String spanName) {
            return new NoopSpanBuilder(spanName);
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null && !this.isRootSpan) {
                this.spanContext = TracingContextUtils.getCurrentSpan().getContext();
            }
            return this.spanContext != null && !SpanContext.getInvalid().equals(this.spanContext) ? new DefaultSpan(this.spanContext) : DefaultSpan.createRandom();
        }

        @Override
        public NoopSpanBuilder setParent(Span parent) {
            Utils.checkNotNull(parent, "parent");
            this.spanContext = parent.getContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setParent(SpanContext remoteParent) {
            Utils.checkNotNull(remoteParent, "remoteParent");
            this.spanContext = remoteParent;
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.isRootSpan = true;
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Map<String, AttributeValue> attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(Link link) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, AttributeValue value) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(Span.Kind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp) {
            Utils.checkArgument(startTimestamp >= 0L, "Negative startTimestamp");
            return this;
        }

        private NoopSpanBuilder(String name) {
            Utils.checkNotNull(name, "name");
        }
    }
}

