/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace.propagation;

import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HttpTraceContext
implements HttpTextFormat<SpanContext> {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    static final String TRACEPARENT = "traceparent";
    static final String TRACESTATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 2 * TraceId.getSize();
    private static final int SPAN_ID_HEX_SIZE = 2 * SpanId.getSize();
    private static final int TRACE_OPTION_HEX_SIZE = 2 * TraceFlags.getSize();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");

    @Override
    public List<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(SpanContext spanContext, C carrier, HttpTextFormat.Setter<C> setter) {
        Utils.checkNotNull(spanContext, "spanContext");
        Utils.checkNotNull(setter, "setter");
        Utils.checkNotNull(carrier, "carrier");
        char[] chars = new char[TRACEPARENT_HEADER_SIZE];
        chars[0] = VERSION.charAt(0);
        chars[1] = VERSION.charAt(1);
        chars[2] = 45;
        spanContext.getTraceId().copyLowerBase16To(chars, 3);
        chars[HttpTraceContext.SPAN_ID_OFFSET - 1] = 45;
        spanContext.getSpanId().copyLowerBase16To(chars, SPAN_ID_OFFSET);
        chars[HttpTraceContext.TRACE_OPTION_OFFSET - 1] = 45;
        spanContext.getTraceFlags().copyLowerBase16To(chars, TRACE_OPTION_OFFSET);
        setter.put(carrier, TRACEPARENT, new String(chars));
        List<Tracestate.Entry> entries = spanContext.getTracestate().getEntries();
        if (entries.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Tracestate.Entry entry : entries) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        setter.put(carrier, TRACESTATE, stringBuilder.toString());
    }

    @Override
    public <C> SpanContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
        TraceFlags traceFlags;
        SpanId spanId;
        TraceId traceId;
        Utils.checkNotNull(carrier, "carrier");
        Utils.checkNotNull(getter, "getter");
        String traceparent = getter.get(carrier, TRACEPARENT);
        if (traceparent == null) {
            throw new IllegalArgumentException("Traceparent not present");
        }
        try {
            Utils.checkArgument(traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-' && (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-', "Missing or malformed TRACEPARENT.");
            traceId = TraceId.fromLowerBase16(traceparent, 3);
            spanId = SpanId.fromLowerBase16(traceparent, SPAN_ID_OFFSET);
            traceFlags = TraceFlags.fromLowerBase16(traceparent, TRACE_OPTION_OFFSET);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid traceparent: " + traceparent, e);
        }
        String tracestate = getter.get(carrier, TRACESTATE);
        try {
            if (tracestate == null || tracestate.isEmpty()) {
                return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, TRACESTATE_DEFAULT);
            }
            Tracestate.Builder tracestateBuilder = Tracestate.builder();
            String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(tracestate);
            Utils.checkArgument(listMembers.length <= 32, "Tracestate has too many elements.");
            for (int i = listMembers.length - 1; i >= 0; --i) {
                String listMember = listMembers[i];
                int index = listMember.indexOf(61);
                Utils.checkArgument(index != -1, "Invalid tracestate list-member format.");
                tracestateBuilder.set(listMember.substring(0, index), listMember.substring(index + 1));
            }
            return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, tracestateBuilder.build());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid tracestate: " + tracestate, e);
        }
    }
}

