/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace.propagation;

import io.opentelemetry.context.propagation.BinaryFormat;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BinaryTraceContext
implements BinaryFormat<SpanContext> {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    private static final byte VERSION_ID = 0;
    private static final int VERSION_ID_OFFSET = 0;
    private static final byte ID_SIZE = 1;
    private static final byte TRACE_ID_FIELD_ID = 0;
    static final int TRACE_ID_FIELD_ID_OFFSET = 1;
    private static final int TRACE_ID_OFFSET = 2;
    private static final byte SPAN_ID_FIELD_ID = 1;
    static final int SPAN_ID_FIELD_ID_OFFSET = 2 + TraceId.getSize();
    private static final int SPAN_ID_OFFSET = SPAN_ID_FIELD_ID_OFFSET + 1;
    private static final byte TRACE_OPTION_FIELD_ID = 2;
    static final int TRACE_OPTION_FIELD_ID_OFFSET = SPAN_ID_OFFSET + SpanId.getSize();
    private static final int TRACE_OPTIONS_OFFSET = TRACE_OPTION_FIELD_ID_OFFSET + 1;
    private static final int REQUIRED_FORMAT_LENGTH = 3 + TraceId.getSize() + SpanId.getSize();
    private static final int ALL_FORMAT_LENGTH = REQUIRED_FORMAT_LENGTH + 1 + TraceFlags.getSize();

    @Override
    public byte[] toByteArray(SpanContext spanContext) {
        Utils.checkNotNull(spanContext, "spanContext");
        byte[] bytes = new byte[ALL_FORMAT_LENGTH];
        bytes[0] = 0;
        bytes[1] = 0;
        spanContext.getTraceId().copyBytesTo(bytes, 2);
        bytes[BinaryTraceContext.SPAN_ID_FIELD_ID_OFFSET] = 1;
        spanContext.getSpanId().copyBytesTo(bytes, SPAN_ID_OFFSET);
        bytes[BinaryTraceContext.TRACE_OPTION_FIELD_ID_OFFSET] = 2;
        spanContext.getTraceFlags().copyBytesTo(bytes, TRACE_OPTIONS_OFFSET);
        return bytes;
    }

    @Override
    public SpanContext fromByteArray(byte[] bytes) {
        Utils.checkNotNull(bytes, "bytes");
        if (bytes.length == 0 || bytes[0] != 0) {
            throw new IllegalArgumentException("Unsupported version.");
        }
        if (bytes.length < REQUIRED_FORMAT_LENGTH) {
            throw new IllegalArgumentException("Invalid input: truncated");
        }
        TraceFlags traceFlags = TraceFlags.getDefault();
        int pos = 1;
        if (bytes[pos] != 0) {
            throw new IllegalArgumentException("Invalid input: expected trace ID at offset " + pos);
        }
        TraceId traceId = TraceId.fromBytes(bytes, pos + 1);
        if (bytes[pos += 1 + TraceId.getSize()] != 1) {
            throw new IllegalArgumentException("Invalid input: expected span ID at offset " + pos);
        }
        SpanId spanId = SpanId.fromBytes(bytes, pos + 1);
        if (bytes.length > (pos += 1 + SpanId.getSize()) && bytes[pos] == 2) {
            if (bytes.length < ALL_FORMAT_LENGTH) {
                throw new IllegalArgumentException("Invalid input: truncated");
            }
            traceFlags = TraceFlags.fromByte(bytes[pos + 1]);
        }
        return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, TRACESTATE_DEFAULT);
    }
}

