/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanContext {
    private static final SpanContext INVALID = new SpanContext(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), Tracestate.getDefault(), false);
    private final TraceId traceId;
    private final SpanId spanId;
    private final TraceFlags traceFlags;
    private final Tracestate tracestate;
    private final boolean isRemote;

    static SpanContext getInvalid() {
        return INVALID;
    }

    public static SpanContext create(TraceId traceId, SpanId spanId, TraceFlags traceFlags, Tracestate tracestate) {
        return new SpanContext(traceId, spanId, traceFlags, tracestate, false);
    }

    public static SpanContext createFromRemoteParent(TraceId traceId, SpanId spanId, TraceFlags traceFlags, Tracestate tracestate) {
        return new SpanContext(traceId, spanId, traceFlags, tracestate, true);
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public SpanId getSpanId() {
        return this.spanId;
    }

    public TraceFlags getTraceFlags() {
        return this.traceFlags;
    }

    public Tracestate getTracestate() {
        return this.tracestate;
    }

    public boolean isValid() {
        return this.traceId.isValid() && this.spanId.isValid();
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)obj;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && this.traceFlags.equals(that.traceFlags) && this.isRemote == that.isRemote;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.traceId, this.spanId, this.traceFlags});
    }

    public String toString() {
        return "SpanContext{traceId=" + this.traceId + ", spanId=" + this.spanId + ", traceFlags=" + this.traceFlags + ", isRemote=" + this.isRemote + "}";
    }

    private SpanContext(TraceId traceId, SpanId spanId, TraceFlags traceFlags, Tracestate tracestate, boolean isRemote) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceFlags = traceFlags;
        this.tracestate = tracestate;
        this.isRemote = isRemote;
    }
}

