/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.AttributeValue;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Event;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import java.util.Map;
import java.util.Random;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DefaultSpan
implements Span {
    private static final Random random = new Random();
    private static final DefaultSpan INVALID = new DefaultSpan(SpanContext.getInvalid());
    private final SpanContext spanContext;

    public static DefaultSpan getInvalid() {
        return INVALID;
    }

    public static DefaultSpan create(SpanContext spanContext) {
        return new DefaultSpan(spanContext);
    }

    static DefaultSpan createRandom() {
        return new DefaultSpan(SpanContext.create(TraceId.generateRandomId(random), SpanId.generateRandomId(random), TraceFlags.getDefault(), Tracestate.getDefault()));
    }

    DefaultSpan(SpanContext spanContext) {
        this.spanContext = spanContext;
    }

    @Override
    public void setAttribute(String key, String value) {
        Utils.checkNotNull(key, "key");
        Utils.checkNotNull(value, "value");
    }

    @Override
    public void setAttribute(String key, long value) {
        Utils.checkNotNull(key, "key");
    }

    @Override
    public void setAttribute(String key, double value) {
        Utils.checkNotNull(key, "key");
    }

    @Override
    public void setAttribute(String key, boolean value) {
        Utils.checkNotNull(key, "key");
    }

    @Override
    public void setAttribute(String key, AttributeValue value) {
        Utils.checkNotNull(key, "key");
        Utils.checkNotNull(value, "value");
    }

    @Override
    public void addEvent(String name) {
    }

    @Override
    public void addEvent(String name, long timestamp) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(timestamp >= 0L, "Negative timestamp");
    }

    @Override
    public void addEvent(String name, Map<String, AttributeValue> attributes) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(attributes, "attributes");
    }

    @Override
    public void addEvent(String name, Map<String, AttributeValue> attributes, long timestamp) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(attributes, "attributes");
        Utils.checkArgument(timestamp >= 0L, "Negative timestamp");
    }

    @Override
    public void addEvent(Event event) {
        Utils.checkNotNull(event, "event");
    }

    @Override
    public void addEvent(Event event, long timestamp) {
        Utils.checkNotNull(event, "event");
        Utils.checkArgument(timestamp >= 0L, "Negative timestamp");
    }

    @Override
    public void setStatus(Status status) {
        Utils.checkNotNull(status, "status");
    }

    @Override
    public void updateName(String name) {
        Utils.checkNotNull(name, "name");
    }

    @Override
    public void end() {
    }

    @Override
    public void end(EndSpanOptions endOptions) {
        Utils.checkNotNull(endOptions, "endOptions");
    }

    @Override
    public SpanContext getContext() {
        return this.spanContext;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    public String toString() {
        return "DefaultSpan";
    }
}

