/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.metrics;

import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.BatchRecorder;
import io.opentelemetry.metrics.Counter;
import io.opentelemetry.metrics.CounterDouble;
import io.opentelemetry.metrics.CounterLong;
import io.opentelemetry.metrics.Gauge;
import io.opentelemetry.metrics.GaugeDouble;
import io.opentelemetry.metrics.GaugeLong;
import io.opentelemetry.metrics.MeasureDouble;
import io.opentelemetry.metrics.MeasureLong;
import io.opentelemetry.metrics.Meter;
import io.opentelemetry.metrics.Metric;
import io.opentelemetry.metrics.Observer;
import io.opentelemetry.metrics.ObserverDouble;
import io.opentelemetry.metrics.ObserverLong;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

public final class DefaultMeter
implements Meter {
    private static final DefaultMeter INSTANCE = new DefaultMeter();
    static final int NAME_MAX_LENGTH = 255;
    static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    public static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public GaugeLong.Builder gaugeLongBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopGaugeLong.NoopBuilder();
    }

    @Override
    public GaugeDouble.Builder gaugeDoubleBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopGaugeDouble.NoopBuilder();
    }

    @Override
    public CounterDouble.Builder counterDoubleBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopCounterDouble.NoopBuilder();
    }

    @Override
    public CounterLong.Builder counterLongBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopCounterLong.NoopBuilder();
    }

    @Override
    public MeasureDouble.Builder measureDoubleBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopMeasureDouble.NoopBuilder();
    }

    @Override
    public MeasureLong.Builder measureLongBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopMeasureLong.NoopBuilder();
    }

    @Override
    public ObserverDouble.Builder observerDoubleBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopObserverDouble.NoopBuilder();
    }

    @Override
    public ObserverLong.Builder observerLongBuilder(String name) {
        Utils.checkNotNull(name, "name");
        Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, ERROR_MESSAGE_INVALID_NAME);
        return new NoopObserverLong.NoopBuilder();
    }

    @Override
    public BatchRecorder newMeasureBatchRecorder() {
        return new NoopBatchRecorder();
    }

    private static abstract class NoopAbstractMetricBuilder<B extends Metric.Builder<B, V>, V>
    implements Metric.Builder<B, V> {
        int labelKeysSize = 0;

        private NoopAbstractMetricBuilder() {
        }

        @Override
        public B setDescription(String description) {
            Utils.checkNotNull(description, "description");
            return this.getThis();
        }

        @Override
        public B setUnit(String unit) {
            Utils.checkNotNull(unit, "unit");
            return this.getThis();
        }

        @Override
        public B setLabelKeys(List<String> labelKeys) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
            return this.getThis();
        }

        @Override
        public B setConstantLabels(Map<String, String> constantLabels) {
            Utils.checkMapKeysNotNull(Utils.checkNotNull(constantLabels, "constantLabels"), "constantLabel");
            return this.getThis();
        }

        protected abstract B getThis();
    }

    private static abstract class NoopAbstractObserverBuilder<B extends Observer.Builder<B, V>, V>
    extends NoopAbstractMetricBuilder<B, V>
    implements Observer.Builder<B, V> {
        private NoopAbstractObserverBuilder() {
        }

        @Override
        public B setMonotonic(boolean monotonic) {
            return (B)((Observer.Builder)this.getThis());
        }
    }

    private static abstract class NoopAbstractCounterBuilder<B extends Counter.Builder<B, V>, V>
    extends NoopAbstractMetricBuilder<B, V>
    implements Counter.Builder<B, V> {
        private NoopAbstractCounterBuilder() {
        }

        @Override
        public B setMonotonic(boolean monotonic) {
            return (B)((Counter.Builder)this.getThis());
        }
    }

    private static abstract class NoopAbstractGaugeBuilder<B extends Gauge.Builder<B, V>, V>
    extends NoopAbstractMetricBuilder<B, V>
    implements Gauge.Builder<B, V> {
        private NoopAbstractGaugeBuilder() {
        }

        @Override
        public B setMonotonic(boolean monotonic) {
            return (B)((Gauge.Builder)this.getThis());
        }
    }

    private static final class NoopBatchRecorder
    implements BatchRecorder {
        private NoopBatchRecorder() {
        }

        @Override
        public BatchRecorder put(MeasureLong measure, long value) {
            Utils.checkNotNull(measure, "measure");
            Utils.checkArgument(value >= 0L, "Unsupported negative values.");
            return this;
        }

        @Override
        public BatchRecorder put(MeasureDouble measure, double value) {
            Utils.checkNotNull(measure, "measure");
            Utils.checkArgument(value >= 0.0, "Unsupported negative values.");
            return this;
        }

        @Override
        public void record() {
        }
    }

    @Immutable
    private static final class NoopObserverLong
    implements ObserverLong {
        private final int labelKeysSize;

        private NoopObserverLong(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void setCallback(Observer.Callback<ObserverLong.Result> metricUpdater) {
            Utils.checkNotNull(metricUpdater, "metricUpdater");
        }

        private static final class NoopBuilder
        extends NoopAbstractObserverBuilder<ObserverLong.Builder, ObserverLong>
        implements ObserverLong.Builder {
            private NoopBuilder() {
            }

            @Override
            protected ObserverLong.Builder getThis() {
                return this;
            }

            @Override
            public ObserverLong build() {
                return new NoopObserverLong(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements Observer.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }
        }
    }

    @Immutable
    private static final class NoopObserverDouble
    implements ObserverDouble {
        private final int labelKeysSize;

        private NoopObserverDouble(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void setCallback(Observer.Callback<ObserverDouble.Result> metricUpdater) {
            Utils.checkNotNull(metricUpdater, "metricUpdater");
        }

        private static final class NoopBuilder
        extends NoopAbstractObserverBuilder<ObserverDouble.Builder, ObserverDouble>
        implements ObserverDouble.Builder {
            private NoopBuilder() {
            }

            @Override
            protected ObserverDouble.Builder getThis() {
                return this;
            }

            @Override
            public ObserverDouble build() {
                return new NoopObserverDouble(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements Observer.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }
        }
    }

    @Immutable
    private static final class NoopMeasureLong
    implements MeasureLong {
        private final int labelKeysSize;

        private NoopMeasureLong(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractMetricBuilder<MeasureLong.Builder, MeasureLong>
        implements MeasureLong.Builder {
            private NoopBuilder() {
            }

            @Override
            protected MeasureLong.Builder getThis() {
                return this;
            }

            @Override
            public MeasureLong build() {
                return new NoopMeasureLong(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements MeasureLong.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }

            @Override
            public void record(long value) {
                Utils.checkArgument(value >= 0L, "Unsupported negative values.");
            }
        }
    }

    @Immutable
    private static final class NoopMeasureDouble
    implements MeasureDouble {
        private final int labelKeysSize;

        private NoopMeasureDouble(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractMetricBuilder<MeasureDouble.Builder, MeasureDouble>
        implements MeasureDouble.Builder {
            private NoopBuilder() {
            }

            @Override
            protected MeasureDouble.Builder getThis() {
                return this;
            }

            @Override
            public MeasureDouble build() {
                return new NoopMeasureDouble(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements MeasureDouble.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }

            @Override
            public void record(double value) {
                Utils.checkArgument(value >= 0.0, "Unsupported negative values.");
            }
        }
    }

    @Immutable
    private static final class NoopCounterLong
    implements CounterLong {
        private final int labelKeysSize;

        private NoopCounterLong(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractCounterBuilder<CounterLong.Builder, CounterLong>
        implements CounterLong.Builder {
            private NoopBuilder() {
            }

            @Override
            protected CounterLong.Builder getThis() {
                return this;
            }

            @Override
            public CounterLong build() {
                return new NoopCounterLong(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements CounterLong.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }

            @Override
            public void add(long delta) {
            }
        }
    }

    @Immutable
    private static final class NoopCounterDouble
    implements CounterDouble {
        private final int labelKeysSize;

        private NoopCounterDouble(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopHandle.INSTANCE;
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return NoopHandle.INSTANCE;
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractCounterBuilder<CounterDouble.Builder, CounterDouble>
        implements CounterDouble.Builder {
            private NoopBuilder() {
            }

            @Override
            protected CounterDouble.Builder getThis() {
                return this;
            }

            @Override
            public CounterDouble build() {
                return new NoopCounterDouble(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements CounterDouble.Handle {
            private static final NoopHandle INSTANCE = new NoopHandle();

            private NoopHandle() {
            }

            @Override
            public void add(double delta) {
            }
        }
    }

    @Immutable
    private static final class NoopGaugeDouble
    implements GaugeDouble {
        private final int labelKeysSize;

        private NoopGaugeDouble(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return new NoopHandle();
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return new NoopHandle();
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractGaugeBuilder<GaugeDouble.Builder, GaugeDouble>
        implements GaugeDouble.Builder {
            private NoopBuilder() {
            }

            @Override
            protected GaugeDouble.Builder getThis() {
                return this;
            }

            @Override
            public GaugeDouble build() {
                return new NoopGaugeDouble(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements GaugeDouble.Handle {
            private NoopHandle() {
            }

            @Override
            public void set(double val) {
            }
        }
    }

    @Immutable
    private static final class NoopGaugeLong
    implements GaugeLong {
        private final int labelKeysSize;

        private NoopGaugeLong(int labelKeysSize) {
            this.labelKeysSize = labelKeysSize;
        }

        @Override
        public NoopHandle getHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return new NoopHandle();
        }

        @Override
        public NoopHandle getDefaultHandle() {
            return new NoopHandle();
        }

        @Override
        public void removeHandle(List<String> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        private static final class NoopBuilder
        extends NoopAbstractGaugeBuilder<GaugeLong.Builder, GaugeLong>
        implements GaugeLong.Builder {
            private NoopBuilder() {
            }

            @Override
            protected GaugeLong.Builder getThis() {
                return this;
            }

            @Override
            public GaugeLong build() {
                return new NoopGaugeLong(this.labelKeysSize);
            }
        }

        @Immutable
        private static final class NoopHandle
        implements GaugeLong.Handle {
            private NoopHandle() {
            }

            @Override
            public void set(long val) {
            }
        }
    }
}

