/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.distributedcontext;

import com.google.auto.value.AutoValue;
import io.opentelemetry.distributedcontext.AutoValue_EntryKey;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class EntryKey {
    public static final int MAX_LENGTH = 255;

    EntryKey() {
    }

    public static EntryKey create(String name) {
        Utils.checkArgument(EntryKey.isValid(name), "Invalid EntryKey name: %s", name);
        return new AutoValue_EntryKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

