/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.distributedcontext;

import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.BinaryFormat;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.distributedcontext.DistributedContext;
import io.opentelemetry.distributedcontext.DistributedContextManager;
import io.opentelemetry.distributedcontext.EmptyDistributedContext;
import io.opentelemetry.distributedcontext.EntryKey;
import io.opentelemetry.distributedcontext.EntryMetadata;
import io.opentelemetry.distributedcontext.EntryValue;
import io.opentelemetry.distributedcontext.unsafe.ContextUtils;
import io.opentelemetry.internal.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultDistributedContextManager
implements DistributedContextManager {
    private static final DefaultDistributedContextManager INSTANCE = new DefaultDistributedContextManager();
    private static final BinaryFormat<DistributedContext> BINARY_FORMAT = new NoopBinaryFormat();
    private static final HttpTextFormat<DistributedContext> HTTP_TEXT_FORMAT = new NoopHttpTextFormat();

    public static DistributedContextManager getInstance() {
        return INSTANCE;
    }

    @Override
    public DistributedContext getCurrentContext() {
        return ContextUtils.getValue();
    }

    @Override
    public DistributedContext.Builder contextBuilder() {
        return new NoopDistributedContextBuilder();
    }

    @Override
    public Scope withContext(DistributedContext distContext) {
        return ContextUtils.withDistributedContext(distContext);
    }

    @Override
    public BinaryFormat<DistributedContext> getBinaryFormat() {
        return BINARY_FORMAT;
    }

    @Override
    public HttpTextFormat<DistributedContext> getHttpTextFormat() {
        return HTTP_TEXT_FORMAT;
    }

    @Immutable
    private static final class NoopHttpTextFormat
    implements HttpTextFormat<DistributedContext> {
        private NoopHttpTextFormat() {
        }

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(DistributedContext distContext, C carrier, HttpTextFormat.Setter<C> setter) {
            Utils.checkNotNull(distContext, "distContext");
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(setter, "setter");
        }

        @Override
        public <C> DistributedContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(getter, "getter");
            return EmptyDistributedContext.getInstance();
        }
    }

    @Immutable
    private static final class NoopBinaryFormat
    implements BinaryFormat<DistributedContext> {
        static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

        private NoopBinaryFormat() {
        }

        @Override
        public byte[] toByteArray(DistributedContext distContext) {
            Utils.checkNotNull(distContext, "distContext");
            return EMPTY_BYTE_ARRAY;
        }

        @Override
        public DistributedContext fromByteArray(byte[] bytes) {
            Utils.checkNotNull(bytes, "bytes");
            return EmptyDistributedContext.getInstance();
        }
    }

    @Immutable
    private static final class NoopDistributedContextBuilder
    implements DistributedContext.Builder {
        private NoopDistributedContextBuilder() {
        }

        @Override
        public DistributedContext.Builder setParent(DistributedContext parent) {
            Utils.checkNotNull(parent, "parent");
            return this;
        }

        @Override
        public DistributedContext.Builder setNoParent() {
            return this;
        }

        @Override
        public DistributedContext.Builder put(EntryKey key, EntryValue value, EntryMetadata tagMetadata) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(tagMetadata, "tagMetadata");
            return this;
        }

        @Override
        public DistributedContext.Builder remove(EntryKey key) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public DistributedContext build() {
            return EmptyDistributedContext.getInstance();
        }
    }
}

