/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry;

import io.opentelemetry.distributedcontext.DefaultDistributedContextManager;
import io.opentelemetry.distributedcontext.DistributedContextManager;
import io.opentelemetry.distributedcontext.spi.DistributedContextManagerProvider;
import io.opentelemetry.metrics.DefaultMeterFactoryProvider;
import io.opentelemetry.metrics.MeterFactory;
import io.opentelemetry.metrics.spi.MeterFactoryProvider;
import io.opentelemetry.trace.DefaultTracerFactoryProvider;
import io.opentelemetry.trace.TracerFactory;
import io.opentelemetry.trace.spi.TracerFactoryProvider;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetry {
    @Nullable
    private static volatile OpenTelemetry instance;
    private final TracerFactory tracerFactory;
    private final MeterFactory meterFactory;
    private final DistributedContextManager contextManager;

    public static TracerFactory getTracerFactory() {
        return OpenTelemetry.getInstance().tracerFactory;
    }

    public static MeterFactory getMeterFactory() {
        return OpenTelemetry.getInstance().meterFactory;
    }

    public static DistributedContextManager getDistributedContextManager() {
        return OpenTelemetry.getInstance().contextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OpenTelemetry getInstance() {
        if (instance != null) return instance;
        Class<OpenTelemetry> clazz = OpenTelemetry.class;
        synchronized (OpenTelemetry.class) {
            if (instance != null) return instance;
            instance = new OpenTelemetry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private OpenTelemetry() {
        TracerFactoryProvider tracerFactoryProvider = OpenTelemetry.loadSpi(TracerFactoryProvider.class);
        this.tracerFactory = tracerFactoryProvider != null ? tracerFactoryProvider.create() : DefaultTracerFactoryProvider.getInstance().create();
        MeterFactoryProvider meterFactoryProvider = OpenTelemetry.loadSpi(MeterFactoryProvider.class);
        this.meterFactory = meterFactoryProvider != null ? meterFactoryProvider.create() : DefaultMeterFactoryProvider.getInstance().create();
        DistributedContextManagerProvider contextManagerProvider = OpenTelemetry.loadSpi(DistributedContextManagerProvider.class);
        this.contextManager = contextManagerProvider != null ? contextManagerProvider.create() : DefaultDistributedContextManager.getInstance();
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    static void reset() {
        instance = null;
    }
}

