/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.trace.AutoValue_TraceState;
import io.opentelemetry.api.trace.AutoValue_TraceState_Entry;
import io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TraceState {
    private static final TraceState DEFAULT = TraceState.builder().build();

    public static TraceState getDefault() {
        return DEFAULT;
    }

    @Nullable
    public String get(String key) {
        for (Entry entry : this.getEntries()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public int size() {
        return this.getEntries().size();
    }

    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    public void forEach(BiConsumer<String, String> consumer) {
        for (Entry entry : this.getEntries()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    abstract List<Entry> getEntries();

    public static TraceStateBuilder builder() {
        return new TraceStateBuilder();
    }

    public TraceStateBuilder toBuilder() {
        return new TraceStateBuilder(this);
    }

    static TraceState create(List<Entry> entries) {
        return new AutoValue_TraceState(Collections.unmodifiableList(entries));
    }

    TraceState() {
    }

    @Immutable
    @AutoValue
    static abstract class Entry {
        static Entry create(String key, String value) {
            return new AutoValue_TraceState_Entry(key, value);
        }

        abstract String getKey();

        abstract String getValue();

        Entry() {
        }
    }
}

