/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.PropagatedSpan;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanContextKey;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = (Span)Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context) {
        Span span = (Span)context.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        return (Span)context.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    public Span setAttribute(String var1, @Nonnull String var2);

    public Span setAttribute(String var1, long var2);

    public Span setAttribute(String var1, double var2);

    public Span setAttribute(String var1, boolean var2);

    public <T> Span setAttribute(AttributeKey<T> var1, @Nonnull T var2);

    default public Span setAttribute(AttributeKey<Long> key, int value) {
        this.setAttribute(key, Long.valueOf(value));
        return this;
    }

    public Span addEvent(String var1);

    public Span addEvent(String var1, long var2);

    public Span addEvent(String var1, Attributes var2);

    public Span addEvent(String var1, Attributes var2, long var3);

    public Span setStatus(StatusCode var1);

    public Span setStatus(StatusCode var1, String var2);

    public Span recordException(Throwable var1);

    public Span recordException(Throwable var1, Attributes var2);

    public Span updateName(String var1);

    public void end();

    public void end(long var1);

    public SpanContext getSpanContext();

    public boolean isRecording();

    default public Context storeInContext(Context context) {
        return context.with(SpanContextKey.KEY, (Object)this);
    }

    public static interface Builder {
        public Builder setParent(Context var1);

        public Builder setNoParent();

        public Builder addLink(SpanContext var1);

        public Builder addLink(SpanContext var1, Attributes var2);

        public Builder setAttribute(String var1, @Nonnull String var2);

        public Builder setAttribute(String var1, long var2);

        public Builder setAttribute(String var1, double var2);

        public Builder setAttribute(String var1, boolean var2);

        public <T> Builder setAttribute(AttributeKey<T> var1, @Nonnull T var2);

        public Builder setSpanKind(Kind var1);

        public Builder setStartTimestamp(long var1);

        public Span startSpan();
    }

    public static enum Kind {
        INTERNAL,
        SERVER,
        CLIENT,
        PRODUCER,
        CONSUMER;

    }
}

