/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.webapp;

import io.opentelemetry.testing.internal.jetty.util.resource.Resource;
import io.opentelemetry.testing.internal.jetty.xml.XmlParser;

public abstract class Descriptor {
    protected Resource _xml;
    protected XmlParser.Node _root;
    protected String _dtd;
    protected boolean _validating;

    public Descriptor(Resource xml) {
        this._xml = xml;
    }

    public abstract XmlParser ensureParser() throws ClassNotFoundException;

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public void parse() throws Exception {
        if (this._root == null) {
            try {
                XmlParser parser = this.ensureParser();
                this._root = parser.parse(this._xml.getInputStream());
                this._dtd = parser.getDTD();
            }
            finally {
                this._xml.close();
            }
        }
    }

    public Resource getResource() {
        return this._xml;
    }

    public XmlParser.Node getRoot() {
        return this._root;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._xml + ")";
    }
}

