/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jackson.datatype.jsr310.deser.key;

import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.datatype.jsr310.deser.key.Jsr310KeyDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;

public class YearKeyDeserializer
extends Jsr310KeyDeserializer {
    public static final YearKeyDeserializer INSTANCE = new YearKeyDeserializer();

    protected YearKeyDeserializer() {
    }

    @Override
    protected Year deserialize(String key, DeserializationContext ctxt) throws IOException {
        try {
            return Year.of(Integer.parseInt(key));
        }
        catch (NumberFormatException nfe) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, new DateTimeException("Number format exception", nfe), key);
        }
        catch (DateTimeException dte) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, dte, key);
        }
    }
}

