/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jackson.databind;

import io.opentelemetry.testing.internal.jackson.annotation.JsonCreator;
import io.opentelemetry.testing.internal.jackson.annotation.JsonFormat;
import io.opentelemetry.testing.internal.jackson.annotation.JsonInclude;
import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.annotation.JsonPOJOBuilder;
import io.opentelemetry.testing.internal.jackson.databind.introspect.AnnotatedAndMetadata;
import io.opentelemetry.testing.internal.jackson.databind.introspect.AnnotatedClass;
import io.opentelemetry.testing.internal.jackson.databind.introspect.AnnotatedConstructor;
import io.opentelemetry.testing.internal.jackson.databind.introspect.AnnotatedMember;
import io.opentelemetry.testing.internal.jackson.databind.introspect.AnnotatedMethod;
import io.opentelemetry.testing.internal.jackson.databind.introspect.BeanPropertyDefinition;
import io.opentelemetry.testing.internal.jackson.databind.introspect.ObjectIdInfo;
import io.opentelemetry.testing.internal.jackson.databind.introspect.PotentialCreators;
import io.opentelemetry.testing.internal.jackson.databind.util.Annotations;
import io.opentelemetry.testing.internal.jackson.databind.util.Converter;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BeanDescription {
    protected final JavaType _type;

    protected BeanDescription(JavaType type) {
        this._type = type;
    }

    public JavaType getType() {
        return this._type;
    }

    public Class<?> getBeanClass() {
        return this._type.getRawClass();
    }

    public boolean isRecordType() {
        return this._type.isRecordType();
    }

    public boolean isNonStaticInnerClass() {
        return this.getClassInfo().isNonStaticInnerClass();
    }

    public abstract AnnotatedClass getClassInfo();

    public abstract ObjectIdInfo getObjectIdInfo();

    public abstract boolean hasKnownClassAnnotations();

    public abstract Annotations getClassAnnotations();

    public abstract List<BeanPropertyDefinition> findProperties();

    public abstract Set<String> getIgnoredPropertyNames();

    public abstract List<BeanPropertyDefinition> findBackReferences();

    public abstract List<AnnotatedConstructor> getConstructors();

    public abstract List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode();

    public abstract List<AnnotatedMethod> getFactoryMethods();

    public abstract List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode();

    public abstract AnnotatedConstructor findDefaultConstructor();

    public abstract PotentialCreators getPotentialCreators();

    public AnnotatedMember findJsonKeyAccessor() {
        return null;
    }

    public abstract AnnotatedMember findJsonValueAccessor();

    public abstract AnnotatedMember findAnyGetter();

    public abstract AnnotatedMember findAnySetterAccessor();

    public abstract AnnotatedMethod findMethod(String var1, Class<?>[] var2);

    public abstract JsonInclude.Value findPropertyInclusion(JsonInclude.Value var1);

    public abstract JsonFormat.Value findExpectedFormat();

    @Deprecated
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value defValue) {
        JsonFormat.Value v = this.findExpectedFormat();
        if (defValue == null) {
            return v;
        }
        if (v == null) {
            return defValue;
        }
        return defValue.withOverrides(v);
    }

    public abstract Converter<Object, Object> findSerializationConverter();

    public abstract Converter<Object, Object> findDeserializationConverter();

    public String findClassDescription() {
        return null;
    }

    public abstract Map<Object, AnnotatedMember> findInjectables();

    public abstract Class<?> findPOJOBuilder();

    public abstract JsonPOJOBuilder.Value findPOJOBuilderConfig();

    public abstract Object instantiateBean(boolean var1);

    public abstract Class<?>[] findDefaultViews();
}

