/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc;

import io.opentelemetry.testing.internal.io.micrometer.common.KeyValue;
import io.opentelemetry.testing.internal.io.micrometer.common.KeyValues;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;

public class DefaultGrpcServerObservationConvention
implements GrpcServerObservationConvention {
    private static final KeyValue STATUS_CODE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue("UNKNOWN");
    private static final KeyValue PEER_NAME_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue("UNKNOWN");
    private static final KeyValue PEER_PORT_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue("UNKNOWN");

    @Override
    public String getName() {
        return "grpc.server";
    }

    @Override
    public String getContextualName(GrpcServerObservationContext context) {
        return context.getFullMethodName();
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(GrpcServerObservationContext context) {
        KeyValue statusCodeKeyValue = context.getStatusCode() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue(context.getStatusCode().name()) : STATUS_CODE_UNKNOWN;
        KeyValue peerNameKeyValue = context.getPeerName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue(context.getPeerName()) : PEER_NAME_UNKNOWN;
        KeyValue peerPortKeyValue = context.getPeerPort() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue(context.getPeerPort().toString()) : PEER_PORT_UNKNOWN;
        return KeyValues.of(statusCodeKeyValue, peerNameKeyValue, peerPortKeyValue, GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(context.getMethodName()), GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue(context.getServiceName()), GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD_TYPE.withValue(context.getMethodType().name()));
    }
}

