/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.context;

import io.opentelemetry.testing.internal.io.micrometer.context.ContextAccessor;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextRegistry;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshot;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshotFactory;
import io.opentelemetry.testing.internal.io.micrometer.context.DefaultContextSnapshot;
import io.opentelemetry.testing.internal.io.micrometer.context.Nullable;
import io.opentelemetry.testing.internal.io.micrometer.context.ThreadLocalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

final class DefaultContextSnapshotFactory
implements ContextSnapshotFactory {
    private static final DefaultContextSnapshot emptyContextSnapshot = new DefaultContextSnapshot(new ContextRegistry(), false);
    private final ContextRegistry contextRegistry;
    private final boolean clearMissing;
    private final Predicate<Object> captureKeyPredicate;

    public DefaultContextSnapshotFactory(ContextRegistry contextRegistry, boolean clearMissing, Predicate<Object> captureKeyPredicate) {
        this.contextRegistry = contextRegistry;
        this.clearMissing = clearMissing;
        this.captureKeyPredicate = captureKeyPredicate;
    }

    private static DefaultContextSnapshot clearingEmptySnapshot(ContextRegistry contextRegistry) {
        return new DefaultContextSnapshot(contextRegistry, true);
    }

    @Override
    public ContextSnapshot captureAll(Object ... contexts) {
        return DefaultContextSnapshotFactory.captureAll(this.contextRegistry, this.captureKeyPredicate, this.clearMissing, contexts);
    }

    static ContextSnapshot captureAll(ContextRegistry contextRegistry, Predicate<Object> keyPredicate, boolean clearMissing, Object ... contexts) {
        DefaultContextSnapshot snapshot = DefaultContextSnapshotFactory.captureFromThreadLocals(keyPredicate, clearMissing, contextRegistry);
        for (Object context : contexts) {
            snapshot = DefaultContextSnapshotFactory.captureFromContext(keyPredicate, clearMissing, contextRegistry, snapshot, context);
        }
        return snapshot != null ? snapshot : (clearMissing ? DefaultContextSnapshotFactory.clearingEmptySnapshot(contextRegistry) : emptyContextSnapshot);
    }

    @Nullable
    private static DefaultContextSnapshot captureFromThreadLocals(Predicate<Object> keyPredicate, boolean clearMissing, ContextRegistry contextRegistry) {
        DefaultContextSnapshot snapshot = null;
        for (ThreadLocalAccessor<?> accessor : contextRegistry.getThreadLocalAccessors()) {
            Object value;
            if (!keyPredicate.test(accessor.key()) || (value = accessor.getValue()) == null) continue;
            snapshot = snapshot != null ? snapshot : new DefaultContextSnapshot(contextRegistry, clearMissing);
            snapshot.put(accessor.key(), value);
        }
        return snapshot;
    }

    @Override
    public ContextSnapshot captureFrom(Object ... contexts) {
        return DefaultContextSnapshotFactory.captureFromContext(this.captureKeyPredicate, this.clearMissing, this.contextRegistry, null, contexts);
    }

    static DefaultContextSnapshot captureFromContext(Predicate<Object> keyPredicate, boolean clearMissing, ContextRegistry contextRegistry, @Nullable DefaultContextSnapshot snapshot, Object ... contexts) {
        for (Object context : contexts) {
            ContextAccessor<?, ?> accessor = contextRegistry.getContextAccessorForRead(context);
            snapshot = snapshot != null ? snapshot : new DefaultContextSnapshot(contextRegistry, clearMissing);
            accessor.readValues(context, keyPredicate, snapshot);
        }
        if (snapshot != null) {
            snapshot.values().removeIf(Objects::isNull);
        }
        return snapshot != null ? snapshot : (clearMissing ? DefaultContextSnapshotFactory.clearingEmptySnapshot(contextRegistry) : emptyContextSnapshot);
    }

    @Override
    public <C> ContextSnapshot.Scope setThreadLocalsFrom(Object sourceContext, String ... keys) {
        if (keys == null || keys.length == 0) {
            return DefaultContextSnapshotFactory.setAllThreadLocalsFrom(sourceContext, this.contextRegistry, this.clearMissing);
        }
        return DefaultContextSnapshotFactory.setThreadLocalsFrom(sourceContext, this.contextRegistry, this.clearMissing, keys);
    }

    static <C> ContextSnapshot.Scope setAllThreadLocalsFrom(Object sourceContext, ContextRegistry contextRegistry, boolean clearMissing) {
        ContextAccessor<?, ?> contextAccessor = contextRegistry.getContextAccessorForRead(sourceContext);
        Map<Object, Object> previousValues = null;
        for (ThreadLocalAccessor<?> threadLocalAccessor : contextRegistry.getThreadLocalAccessors()) {
            Object key = threadLocalAccessor.key();
            Object value = contextAccessor.readValue(sourceContext, key);
            if (value != null) {
                previousValues = DefaultContextSnapshot.setThreadLocal(key, value, threadLocalAccessor, previousValues);
                continue;
            }
            if (!clearMissing) continue;
            previousValues = DefaultContextSnapshot.clearThreadLocal(key, threadLocalAccessor, previousValues);
        }
        return DefaultContextSnapshot.DefaultScope.from(previousValues, contextRegistry);
    }

    static <C> ContextSnapshot.Scope setThreadLocalsFrom(Object sourceContext, ContextRegistry contextRegistry, boolean clearMissing, String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("You must provide at least one key when setting thread locals");
        }
        ContextAccessor<?, ?> contextAccessor = contextRegistry.getContextAccessorForRead(sourceContext);
        Map<Object, Object> previousValues = null;
        List<ThreadLocalAccessor<?>> accessors = contextRegistry.getThreadLocalAccessors();
        block0: for (String key : keys) {
            Object value = contextAccessor.readValue(sourceContext, key);
            if (value != null) {
                for (ThreadLocalAccessor<?> threadLocalAccessor : accessors) {
                    if (!key.equals(threadLocalAccessor.key())) continue;
                    previousValues = DefaultContextSnapshot.setThreadLocal(key, value, threadLocalAccessor, previousValues);
                    continue block0;
                }
                continue;
            }
            if (!clearMissing) continue;
            for (ThreadLocalAccessor<?> threadLocalAccessor : accessors) {
                if (!key.equals(threadLocalAccessor.key())) continue;
                previousValues = DefaultContextSnapshot.clearThreadLocal(key, threadLocalAccessor, previousValues);
                continue block0;
            }
        }
        return DefaultContextSnapshot.DefaultScope.from(previousValues, contextRegistry);
    }

    static final class Builder
    implements ContextSnapshotFactory.Builder {
        private boolean clearMissing = false;
        private ContextRegistry contextRegistry = ContextRegistry.getInstance();
        private Predicate<Object> captureKeyPredicate = key -> true;

        @Override
        public ContextSnapshotFactory build() {
            return new DefaultContextSnapshotFactory(this.contextRegistry, this.clearMissing, this.captureKeyPredicate);
        }

        @Override
        public ContextSnapshotFactory.Builder clearMissing(boolean shouldClear) {
            this.clearMissing = shouldClear;
            return this;
        }

        @Override
        public ContextSnapshotFactory.Builder contextRegistry(ContextRegistry contextRegistry) {
            this.contextRegistry = contextRegistry;
            return this;
        }

        @Override
        public ContextSnapshotFactory.Builder captureKeyPredicate(Predicate<Object> captureKeyPredicate) {
            this.captureKeyPredicate = captureKeyPredicate;
            return this;
        }
    }
}

