/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.guava.collect;

import com.google.j2objc.annotations.Weak;
import io.opentelemetry.testing.internal.guava.annotations.GwtCompatible;
import io.opentelemetry.testing.internal.guava.base.Objects;
import io.opentelemetry.testing.internal.guava.base.Preconditions;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.guava.base.Predicates;
import io.opentelemetry.testing.internal.guava.collect.FilteredMultimap;
import io.opentelemetry.testing.internal.guava.collect.Iterables;
import io.opentelemetry.testing.internal.guava.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible
final class FilteredMultimapValues<K, V>
extends AbstractCollection<V> {
    @Weak
    private final FilteredMultimap<K, V> multimap;

    FilteredMultimapValues(FilteredMultimap<K, V> multimap) {
        this.multimap = Preconditions.checkNotNull(multimap);
    }

    @Override
    public Iterator<V> iterator() {
        return Maps.valueIterator(this.multimap.entries().iterator());
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.multimap.containsValue(o);
    }

    @Override
    public int size() {
        return this.multimap.size();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        Predicate<Map.Entry<K, V>> entryPredicate = this.multimap.entryPredicate();
        Iterator<Map.Entry<K, V>> unfilteredItr = this.multimap.unfiltered().entries().iterator();
        while (unfilteredItr.hasNext()) {
            Map.Entry<K, V> entry = unfilteredItr.next();
            if (!entryPredicate.apply(entry) || !Objects.equal(entry.getValue(), o)) continue;
            unfilteredItr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.in(c))));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(c)))));
    }

    @Override
    public void clear() {
        this.multimap.clear();
    }
}

