/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.websocket;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocket;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceOptions;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.websocket.WebSocketProtocolHandler;
import io.opentelemetry.testing.internal.armeria.server.websocket.WebSocketServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.websocket.WebSocketServiceHandler;
import io.opentelemetry.testing.internal.armeria.server.websocket.WebSocketUpgradeResult;

@UnstableApi
public interface WebSocketService
extends HttpService {
    public static WebSocketService of(WebSocketServiceHandler handler) {
        return new WebSocketServiceBuilder(handler).build();
    }

    public static WebSocketServiceBuilder builder(WebSocketServiceHandler handler) {
        return new WebSocketServiceBuilder(handler);
    }

    @Override
    default public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        WebSocketUpgradeResult upgradeResult = this.protocolHandler().upgrade(ctx, req);
        if (!upgradeResult.isSuccess()) {
            return upgradeResult.fallbackResponse();
        }
        WebSocket in = this.protocolHandler().decode(ctx, req);
        WebSocket out = this.serve(ctx, in);
        return this.protocolHandler().encode(ctx, out);
    }

    @Override
    public WebSocket serve(ServiceRequestContext var1, WebSocket var2) throws Exception;

    public WebSocketProtocolHandler protocolHandler();

    @Override
    default public ServiceOptions options() {
        return WebSocketServiceBuilder.DEFAULT_OPTIONS;
    }
}

