/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptionInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldInfoBuilder;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldLocation;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldRequirement;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

@UnstableApi
public final class FieldInfo {
    private final String name;
    private final FieldLocation location;
    private final FieldRequirement requirement;
    private final TypeSignature typeSignature;
    private final DescriptionInfo descriptionInfo;

    public static FieldInfo of(String name, TypeSignature typeSignature) {
        return new FieldInfo(name, FieldLocation.UNSPECIFIED, FieldRequirement.UNSPECIFIED, typeSignature, DescriptionInfo.empty());
    }

    public static FieldInfo of(String name, TypeSignature typeSignature, DescriptionInfo descriptionInfo) {
        return new FieldInfo(name, FieldLocation.UNSPECIFIED, FieldRequirement.UNSPECIFIED, typeSignature, descriptionInfo);
    }

    public static FieldInfoBuilder builder(String name, TypeSignature typeSignature) {
        return new FieldInfoBuilder(name, typeSignature);
    }

    FieldInfo(String name, FieldLocation location, FieldRequirement requirement, TypeSignature typeSignature, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.location = Objects.requireNonNull(location, "name");
        this.requirement = Objects.requireNonNull(requirement, "requirement");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature");
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public FieldLocation location() {
        return this.location;
    }

    @JsonProperty
    public FieldRequirement requirement() {
        return this.requirement;
    }

    @JsonProperty
    public TypeSignature typeSignature() {
        return this.typeSignature;
    }

    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public FieldInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new FieldInfo(this.name, this.location, this.requirement, this.typeSignature, descriptionInfo);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return this.name.equals(that.name) && this.location == that.location && this.requirement == that.requirement && this.typeSignature.equals(that.typeSignature) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.location, this.requirement, this.typeSignature, this.descriptionInfo});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("location", (Object)this.location).add("requirement", (Object)this.requirement).add("typeSignature", this.typeSignature).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

