/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.internal.common.SslContextFactory;
import io.opentelemetry.testing.internal.armeria.internal.common.TlsProviderUtil;
import io.opentelemetry.testing.internal.armeria.server.ServerTlsConfig;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import io.opentelemetry.testing.internal.io.netty.util.Mapping;

final class TlsProviderMapping
implements Mapping<String, SslContext> {
    private final SslContextFactory sslContextFactory;

    TlsProviderMapping(TlsProvider tlsProvider, TlsEngineType tlsEngineType, @Nullable ServerTlsConfig tlsConfig, MeterRegistry meterRegistry) {
        this.sslContextFactory = new SslContextFactory(tlsProvider, tlsEngineType, tlsConfig, meterRegistry);
    }

    @Override
    public SslContext map(@Nullable String hostname) {
        hostname = hostname == null ? "*" : TlsProviderUtil.normalizeHostname(hostname);
        return this.sslContextFactory.getOrCreate(SslContextFactory.SslContextMode.SERVER, hostname);
    }

    void release(SslContext sslContext) {
        this.sslContextFactory.release(sslContext);
    }
}

