/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.legacy.math.linearalgebra;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;

public class PolynomialGF2mSmallM {
    private GF2mField field;
    private int degree;
    private int[] coefficients;

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n) {
        this.field = gF2mField;
        this.degree = n;
        this.coefficients = new int[n + 1];
        this.coefficients[n] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.coefficients = PolynomialGF2mSmallM.normalForm(nArray);
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, byte[] byArray) {
        int n;
        this.field = gF2mField;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length % n2 != 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.coefficients = new int[byArray.length / n2];
        n2 = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < n; j += 8) {
                int n3 = i;
                this.coefficients[n3] = this.coefficients[n3] ^ (byArray[n2++] & 0xFF) << j;
            }
            if (this.field.isElementOfThisField(this.coefficients[i])) continue;
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        if (this.coefficients.length != 1 && this.coefficients[this.coefficients.length - 1] == 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = polynomialGF2mSmallM.field;
        this.degree = polynomialGF2mSmallM.degree;
        this.coefficients = IntUtils.clone(polynomialGF2mSmallM.coefficients);
    }

    public int getDegree() {
        int n = this.coefficients.length - 1;
        if (this.coefficients[n] == 0) {
            return -1;
        }
        return n;
    }

    private static int headCoefficient(int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            return 0;
        }
        return nArray[n];
    }

    public int getCoefficient(int n) {
        if (n < 0 || n > this.degree) {
            return 0;
        }
        return this.coefficients[n];
    }

    public byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        byte[] byArray = new byte[this.coefficients.length * n2];
        n2 = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < n; j += 8) {
                byArray[n2++] = (byte)(this.coefficients[i] >>> j);
            }
        }
        return byArray;
    }

    public int evaluateAt(int n) {
        int n2 = this.coefficients[this.degree];
        for (int i = this.degree - 1; i >= 0; --i) {
            n2 = this.field.mult(n2, n) ^ this.coefficients[i];
        }
        return n2;
    }

    public void addToThis(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.coefficients = this.add(this.coefficients, polynomialGF2mSmallM.coefficients);
        this.computeDegree();
    }

    private int[] add(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4;
        if (nArray.length < nArray2.length) {
            nArray4 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            nArray3 = nArray;
        } else {
            nArray4 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
            nArray3 = nArray2;
        }
        for (int i = nArray3.length - 1; i >= 0; --i) {
            nArray4[i] = this.field.add(nArray4[i], nArray3[i]);
        }
        return nArray4;
    }

    public PolynomialGF2mSmallM multWithElement(int n) {
        if (!this.field.isElementOfThisField(n)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        int[] nArray = this.multWithElement(this.coefficients, n);
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public void multThisWithElement(int n) {
        if (!this.field.isElementOfThisField(n)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        this.coefficients = this.multWithElement(this.coefficients, n);
        this.computeDegree();
    }

    private int[] multWithElement(int[] nArray, int n) {
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 == -1 || n == 0) {
            return new int[1];
        }
        if (n == 1) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n2 + 1];
        for (int i = n2; i >= 0; --i) {
            nArray2[i] = this.field.mult(nArray[i], n);
        }
        return nArray2;
    }

    private static int[] multWithMonomial(int[] nArray, int n) {
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 == -1) {
            return new int[1];
        }
        int[] nArray2 = new int[n2 + n + 1];
        System.arraycopy(nArray, 0, nArray2, n, n2 + 1);
        return nArray2;
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = this.mod(this.coefficients, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    private int[] mod(int[] nArray, int[] nArray2) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray2);
        if (n == -1) {
            throw new ArithmeticException("Division by zero");
        }
        int[] nArray3 = new int[nArray.length];
        int n2 = PolynomialGF2mSmallM.headCoefficient(nArray2);
        n2 = this.field.inverse(n2);
        System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
        while (n <= PolynomialGF2mSmallM.computeDegree(nArray3)) {
            int n3 = this.field.mult(PolynomialGF2mSmallM.headCoefficient(nArray3), n2);
            int[] nArray4 = PolynomialGF2mSmallM.multWithMonomial(nArray2, PolynomialGF2mSmallM.computeDegree(nArray3) - n);
            nArray4 = this.multWithElement(nArray4, n3);
            nArray3 = this.add(nArray4, nArray3);
        }
        return nArray3;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PolynomialGF2mSmallM)) {
            return false;
        }
        PolynomialGF2mSmallM polynomialGF2mSmallM = (PolynomialGF2mSmallM)object;
        return this.field.equals(polynomialGF2mSmallM.field) && this.degree == polynomialGF2mSmallM.degree && PolynomialGF2mSmallM.isEqual(this.coefficients, polynomialGF2mSmallM.coefficients);
    }

    private static boolean isEqual(int[] nArray, int[] nArray2) {
        int n;
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 != (n = PolynomialGF2mSmallM.computeDegree(nArray2))) {
            return false;
        }
        for (int i = 0; i <= n2; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.field.hashCode();
        for (int i = 0; i < this.coefficients.length; ++i) {
            n = n * 31 + this.coefficients[i];
        }
        return n;
    }

    public String toString() {
        String string = " Polynomial over " + this.field.toString() + ": \n";
        for (int i = 0; i < this.coefficients.length; ++i) {
            string = string + this.field.elementToStr(this.coefficients[i]) + "Y^" + i + "+";
        }
        string = string + ";";
        return string;
    }

    private void computeDegree() {
        this.degree = this.coefficients.length - 1;
        while (this.degree >= 0 && this.coefficients[this.degree] == 0) {
            --this.degree;
        }
    }

    private static int computeDegree(int[] nArray) {
        int n;
        for (n = nArray.length - 1; n >= 0 && nArray[n] == 0; --n) {
        }
        return n;
    }

    private static int[] normalForm(int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            return new int[1];
        }
        if (nArray.length == n + 1) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n + 1);
        return nArray2;
    }
}

