/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.sphincsplus;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSPlusPrivateKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCSPHINCSPlusPrivateKey
implements SPHINCSPlusPrivateKey,
PrivateKey {
    private transient SPHINCSPlusPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSPHINCSPlusPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SPHINCSPlusPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSPHINCSPlusPrivateKey) {
            BCSPHINCSPlusPrivateKey bCSPHINCSPlusPrivateKey = (BCSPHINCSPlusPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSPHINCSPlusPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS+";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

