/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.falcon;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.FalconPublicKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public class BCFalconPublicKey
implements FalconPublicKey {
    private transient FalconPublicKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;

    public BCFalconPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init((FalconPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    private void init(FalconPublicKeyParameters falconPublicKeyParameters) {
        this.params = falconPublicKeyParameters;
        this.algorithm = Strings.toUpperCase(falconPublicKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCFalconPublicKey) {
            BCFalconPublicKey bCFalconPublicKey = (BCFalconPublicKey)object;
            return Arrays.areEqual(this.getEncoded(), bCFalconPublicKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(this.params);
        }
        return Arrays.clone(this.encoding);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

