/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;

public class MLKEMPrivateKeyParameters
extends MLKEMKeyParameters {
    final byte[] s;
    final byte[] hpk;
    final byte[] nonce;
    final byte[] t;
    final byte[] rho;
    final byte[] seed;
    private final int prefFormat;

    public MLKEMPrivateKeyParameters(MLKEMParameters mLKEMParameters, byte[] byArray) {
        this(mLKEMParameters, byArray, null);
    }

    public MLKEMPrivateKeyParameters(MLKEMParameters mLKEMParameters, byte[] byArray, MLKEMPublicKeyParameters mLKEMPublicKeyParameters) {
        super(true, mLKEMParameters);
        MLKEMEngine mLKEMEngine = mLKEMParameters.getEngine();
        if (byArray.length == 64) {
            byte[][] byArray2 = mLKEMEngine.generateKemKeyPairInternal(Arrays.copyOfRange(byArray, 0, 32), Arrays.copyOfRange(byArray, 32, byArray.length));
            this.s = byArray2[2];
            this.hpk = byArray2[3];
            this.nonce = byArray2[4];
            this.t = byArray2[0];
            this.rho = byArray2[1];
            this.seed = byArray2[5];
        } else {
            int n = 0;
            this.s = Arrays.copyOfRange(byArray, 0, mLKEMEngine.getKyberIndCpaSecretKeyBytes());
            this.t = Arrays.copyOfRange(byArray, n += mLKEMEngine.getKyberIndCpaSecretKeyBytes(), n + mLKEMEngine.getKyberIndCpaPublicKeyBytes() - 32);
            this.rho = Arrays.copyOfRange(byArray, n += mLKEMEngine.getKyberIndCpaPublicKeyBytes() - 32, n + 32);
            this.hpk = Arrays.copyOfRange(byArray, n += 32, n + 32);
            this.nonce = Arrays.copyOfRange(byArray, n += 32, n + 32);
            this.seed = null;
        }
        if (!(mLKEMPublicKeyParameters == null || Arrays.constantTimeAreEqual(this.t, mLKEMPublicKeyParameters.t) && Arrays.constantTimeAreEqual(this.rho, mLKEMPublicKeyParameters.rho))) {
            throw new IllegalArgumentException("passed in public key does not match private values");
        }
        this.prefFormat = this.seed == null ? 2 : 0;
    }

    public int getPreferredFormat() {
        return this.prefFormat;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.s, this.t, this.rho, this.hpk, this.nonce});
    }

    public byte[] getPublicKey() {
        return MLKEMPublicKeyParameters.getEncoded(this.t, this.rho);
    }

    public MLKEMPublicKeyParameters getPublicKeyParameters() {
        return new MLKEMPublicKeyParameters(this.getParameters(), this.t, this.rho);
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }
}

