/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.io;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

class SignatureUpdatingOutputStream
extends OutputStream {
    private Signature sig;

    SignatureUpdatingOutputStream(Signature signature) {
        this.sig = signature;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.sig.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw Exceptions.ioException(signatureException.getMessage(), signatureException);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            this.sig.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw Exceptions.ioException(signatureException.getMessage(), signatureException);
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.sig.update((byte)n);
        }
        catch (SignatureException signatureException) {
            throw Exceptions.ioException(signatureException.getMessage(), signatureException);
        }
    }
}

